/*
 * Decompiled with CFR 0.152.
 */
package io.crate.copy.azure;

import io.crate.execution.engine.collect.files.Globs;
import java.net.URI;
import org.jetbrains.annotations.Nullable;

public record AzureURI(String account, String container, String endpoint, String resourcePath, Globs.GlobPredicate globPredicate) {
    public static AzureURI of(URI uri) {
        if (!uri.getScheme().equals("az")) {
            throw new IllegalArgumentException("Invalid URI. URI must look like 'az://account.endpoint_suffix/container/path/to/file'");
        }
        Object endpoint = uri.getHost();
        int port = uri.getPort();
        if (port != -1) {
            endpoint = (String)endpoint + ":" + port;
        }
        String path = uri.getPath();
        int dotIndex = ((String)endpoint).indexOf(".");
        if (dotIndex < 0) {
            throw new IllegalArgumentException("Invalid URI. URI must look like 'az://account.endpoint_suffix/container/path/to/file'");
        }
        String account = ((String)endpoint).substring(0, dotIndex);
        assert (path.charAt(0) == '/') : "URI path starts with /";
        int secondSlashIndex = path.indexOf(47, 1);
        if (secondSlashIndex < 0) {
            throw new IllegalArgumentException("Invalid URI. URI must look like 'az://account.endpoint_suffix/container/path/to/file'");
        }
        if (path.length() - secondSlashIndex < 2) {
            throw new IllegalArgumentException("Invalid URI. Path after container cannot be empty");
        }
        String container = path.substring(1, secondSlashIndex);
        String resourcePath = path.substring(secondSlashIndex);
        Globs.GlobPredicate globPredicate = new Globs.GlobPredicate(resourcePath.substring(1));
        return new AzureURI(account, container, (String)endpoint, resourcePath, globPredicate);
    }

    @Nullable
    public String preGlobPath() {
        int asteriskIndex = this.resourcePath.indexOf("*");
        if (asteriskIndex < 0) {
            return null;
        }
        int lastBeforeAsterisk = 0;
        for (int i = asteriskIndex; i >= 0; --i) {
            if (this.resourcePath.charAt(i) != '/') continue;
            lastBeforeAsterisk = i;
            break;
        }
        assert (this.resourcePath.charAt(0) == '/') : "Resource path must start with the forwarding slash.";
        return this.resourcePath.substring(0, lastBeforeAsterisk + 1);
    }

    public boolean matchesGlob(String path) {
        return this.globPredicate.test(path);
    }
}

