/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.Table;
import java.util.Objects;

public class AlterTableRenameColumn<T>
extends Statement {
    private final Table<T> table;
    private final Expression column;
    private final Expression newName;

    public AlterTableRenameColumn(Table<T> table, Expression column, Expression newName) {
        this.table = table;
        this.column = column;
        this.newName = newName;
    }

    public Table<T> table() {
        return this.table;
    }

    public Expression column() {
        return this.column;
    }

    public Expression newName() {
        return this.newName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AlterTableRenameColumn)) return false;
        AlterTableRenameColumn that = (AlterTableRenameColumn)o;
        if (!this.table.equals(that.table)) return false;
        if (!this.column.equals(that.column)) return false;
        if (!this.newName.equals(that.newName)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.column, this.newName);
    }

    @Override
    public String toString() {
        return "AlterTableRenameColumn{table=" + String.valueOf(this.table) + ", column=" + String.valueOf(this.column) + ", newName=" + String.valueOf(this.newName) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAlterTableRenameColumnStatement(this, context);
    }
}

