/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Node;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class ClusteredBy<T>
extends Node {
    private final Optional<T> column;
    private final Optional<T> numberOfShards;

    public ClusteredBy(Optional<T> column, Optional<T> numberOfShards) {
        this.column = column;
        this.numberOfShards = numberOfShards;
    }

    public Optional<T> column() {
        return this.column;
    }

    public Optional<T> numberOfShards() {
        return this.numberOfShards;
    }

    public <U> ClusteredBy<U> map(Function<? super T, ? extends U> mapper) {
        return new ClusteredBy<U>(this.column.map(mapper), this.numberOfShards.map(mapper));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteredBy that = (ClusteredBy)o;
        return Objects.equals(this.column, that.column) && Objects.equals(this.numberOfShards, that.numberOfShards);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.column, this.numberOfShards);
    }

    @Override
    public String toString() {
        return "ClusteredBy{column=" + String.valueOf(this.column) + ", number of shards=" + String.valueOf(this.numberOfShards) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitClusteredBy(this, context);
    }
}

