/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.CheckColumnConstraint;
import io.crate.sql.tree.ColumnConstraint;
import io.crate.sql.tree.ColumnStorageDefinition;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.DefaultConstraint;
import io.crate.sql.tree.GeneratedExpressionConstraint;
import io.crate.sql.tree.IndexColumnConstraint;
import io.crate.sql.tree.NotNullColumnConstraint;
import io.crate.sql.tree.NullColumnConstraint;
import io.crate.sql.tree.PrimaryKeyColumnConstraint;
import io.crate.sql.tree.TableElement;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class ColumnDefinition<T>
extends TableElement<T> {
    private final String ident;
    @Nullable
    private final ColumnType<T> type;
    private final List<ColumnConstraint<T>> constraints;

    public ColumnDefinition(String ident, @Nullable ColumnType<T> type, List<ColumnConstraint<T>> constraints) {
        this.ident = ident;
        this.type = type;
        this.constraints = constraints;
        ColumnDefinition.validateColumnConstraints(ident, type, constraints);
    }

    static <T> void validateColumnConstraints(String ident, @Nullable ColumnType<T> type, List<ColumnConstraint<T>> constraints) {
        boolean[] hasConstraint = new boolean[5];
        block10: for (ColumnConstraint<T> constraint : constraints) {
            ColumnConstraint<T> columnConstraint;
            Objects.requireNonNull(constraint);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PrimaryKeyColumnConstraint.class, IndexColumnConstraint.class, DefaultConstraint.class, GeneratedExpressionConstraint.class, ColumnStorageDefinition.class, CheckColumnConstraint.class, NotNullColumnConstraint.class, NullColumnConstraint.class}, columnConstraint, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    PrimaryKeyColumnConstraint ignored = (PrimaryKeyColumnConstraint)columnConstraint;
                    if (hasConstraint[0]) {
                        throw new IllegalArgumentException("Column [" + ident + "]: multiple primary key constraints found");
                    }
                    hasConstraint[0] = true;
                    continue block10;
                }
                case 1: {
                    IndexColumnConstraint ignored = (IndexColumnConstraint)columnConstraint;
                    if (hasConstraint[1]) {
                        throw new IllegalArgumentException("Column [" + ident + "]: multiple index constraints found");
                    }
                    hasConstraint[1] = true;
                    continue block10;
                }
                case 2: {
                    DefaultConstraint ignored = (DefaultConstraint)columnConstraint;
                    if (hasConstraint[2]) {
                        throw new IllegalArgumentException("Column [" + ident + "]: multiple default constraints found");
                    }
                    hasConstraint[2] = true;
                    continue block10;
                }
                case 3: {
                    GeneratedExpressionConstraint ignored = (GeneratedExpressionConstraint)columnConstraint;
                    if (hasConstraint[3]) {
                        throw new IllegalArgumentException("Column [" + ident + "]: multiple generated constraints found");
                    }
                    hasConstraint[3] = true;
                    continue block10;
                }
                case 4: {
                    ColumnStorageDefinition ignored = (ColumnStorageDefinition)columnConstraint;
                    if (hasConstraint[4]) {
                        throw new IllegalArgumentException("Column [" + ident + "]: multiple storage constraints found");
                    }
                    hasConstraint[4] = true;
                    continue block10;
                }
                case 5: {
                    CheckColumnConstraint ignored = (CheckColumnConstraint)columnConstraint;
                    continue block10;
                }
                case 6: {
                    NotNullColumnConstraint ignored = (NotNullColumnConstraint)columnConstraint;
                    continue block10;
                }
                case 7: 
            }
            NullColumnConstraint nullColumnConstraint = (NullColumnConstraint)columnConstraint;
        }
        if (type == null && !hasConstraint[3]) {
            throw new IllegalArgumentException("Column [" + ident + "]: data type needs to be provided or column should be defined as a generated expression");
        }
        if (hasConstraint[2] && hasConstraint[3]) {
            throw new IllegalArgumentException("Column [" + ident + "]: the default and generated expressions are mutually exclusive");
        }
    }

    public String ident() {
        return this.ident;
    }

    @Nullable
    public ColumnType<T> type() {
        return this.type;
    }

    public List<ColumnConstraint<T>> constraints() {
        return this.constraints;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDefinition that = (ColumnDefinition)o;
        return Objects.equals(this.ident, that.ident) && Objects.equals(this.type, that.type) && Objects.equals(this.constraints, that.constraints);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ident, this.type, this.constraints);
    }

    @Override
    public String toString() {
        return "ColumnDefinition{ident='" + this.ident + "', type=" + String.valueOf(this.type) + ", constraints=" + String.valueOf(this.constraints) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitColumnDefinition(this, context);
    }

    @Override
    public void visit(Consumer<? super T> consumer) {
        for (ColumnConstraint<? super T> columnConstraint : this.constraints) {
            columnConstraint.visit(consumer);
        }
    }
}

