/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Literal;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class IntervalLiteral
extends Literal {
    private final String value;
    private final Sign sign;
    private final IntervalField startField;
    @Nullable
    private final IntervalField endField;

    public IntervalLiteral(String value, Sign sign, IntervalField startField, @Nullable IntervalField endField) {
        this.value = value;
        this.sign = sign;
        this.startField = startField;
        this.endField = endField;
    }

    public String getValue() {
        return this.value;
    }

    public Sign getSign() {
        return this.sign;
    }

    public IntervalField getStartField() {
        return this.startField;
    }

    @Nullable
    public IntervalField getEndField() {
        return this.endField;
    }

    public static String format(IntervalLiteral i) {
        StringBuilder builder = new StringBuilder("INTERVAL ");
        if (i.getSign() == Sign.MINUS) {
            builder.append("- ");
        }
        builder.append("'");
        builder.append(i.getValue());
        builder.append("' ").append(i.getStartField().name());
        IntervalField endField = i.getEndField();
        if (endField != null) {
            builder.append(" TO ").append(endField.name());
        }
        return builder.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.sign, this.startField, this.endField});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntervalLiteral other = (IntervalLiteral)obj;
        return Objects.equals(this.value, other.value) && Objects.equals((Object)this.sign, (Object)other.sign) && Objects.equals((Object)this.startField, (Object)other.startField) && Objects.equals((Object)this.endField, (Object)other.endField);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIntervalLiteral(this, context);
    }

    public static enum Sign {
        PLUS,
        MINUS;

    }

    public static enum IntervalField {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND;

    }
}

