/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.RerouteOption;
import java.util.Objects;
import java.util.function.Function;

public class PromoteReplica<T>
extends RerouteOption {
    private final T node;
    private final T shardId;
    private final GenericProperties<T> properties;

    public PromoteReplica(T node, T shardId, GenericProperties<T> properties) {
        this.node = node;
        this.shardId = shardId;
        this.properties = properties;
    }

    public T node() {
        return this.node;
    }

    public T shardId() {
        return this.shardId;
    }

    public GenericProperties<T> properties() {
        return this.properties;
    }

    public <U> PromoteReplica<U> map(Function<? super T, ? extends U> mapper) {
        return new PromoteReplica<U>(mapper.apply(this.node), mapper.apply(this.shardId), this.properties.map(mapper));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PromoteReplica that = (PromoteReplica)o;
        return Objects.equals(this.node, that.node) && Objects.equals(this.shardId, that.shardId) && Objects.equals(this.properties, that.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.node, this.shardId, this.properties);
    }

    @Override
    public String toString() {
        return "PromoteReplica{node=" + String.valueOf(this.node) + ", shardId=" + String.valueOf(this.shardId) + ", properties=" + String.valueOf(this.properties) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitReroutePromoteReplica(this, context);
    }

    public static class Properties {
        public static final String ACCEPT_DATA_LOSS = "accept_data_loss";
    }
}

