/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.SelectItem;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class SingleColumn
extends SelectItem {
    @Nullable
    private final String alias;
    private final Expression expression;

    public SingleColumn(Expression expression, @Nullable String alias) {
        this.expression = expression;
        this.alias = alias;
    }

    public SingleColumn(Expression expression) {
        this(expression, null);
    }

    @Nullable
    public String getAlias() {
        return this.alias;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleColumn that = (SingleColumn)o;
        return Objects.equals(this.alias, that.alias) && Objects.equals(this.expression, that.expression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alias, this.expression);
    }

    @Override
    public String toString() {
        if (this.alias != null) {
            return this.expression.toString() + " " + this.alias;
        }
        return this.expression.toString();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSingleColumn(this, context);
    }
}

