/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Statement;
import java.util.Objects;

public final class SwapTable<T>
extends Statement {
    private final QualifiedName source;
    private final QualifiedName target;
    private final GenericProperties<T> properties;

    public SwapTable(QualifiedName source, QualifiedName target, GenericProperties<T> properties) {
        this.source = source;
        this.target = target;
        this.properties = properties;
    }

    public QualifiedName source() {
        return this.source;
    }

    public QualifiedName target() {
        return this.target;
    }

    public GenericProperties<T> properties() {
        return this.properties;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSwapTable(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwapTable swapTable = (SwapTable)o;
        return Objects.equals(this.source, swapTable.source) && Objects.equals(this.target, swapTable.target) && Objects.equals(this.properties, swapTable.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.target, this.properties);
    }

    @Override
    public String toString() {
        return "SwapTable{source=" + String.valueOf(this.source) + ", target=" + String.valueOf(this.target) + ", properties=" + String.valueOf(this.properties) + "}";
    }
}

