/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.Query;
import java.util.List;
import java.util.Objects;

public class WithQuery
extends Node {
    private final String name;
    private final Query query;
    private final List<String> columnNames;

    public WithQuery(String name, Query query, List<String> columnNames) {
        this.name = name;
        this.query = Objects.requireNonNull(query, "query is null");
        this.columnNames = columnNames;
    }

    public String name() {
        return this.name;
    }

    public Query query() {
        return this.query;
    }

    public List<String> columnNames() {
        return this.columnNames;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWithQuery(this, context);
    }

    @Override
    public String toString() {
        return "WithQuery{name=" + this.name + ", query=" + String.valueOf(this.query) + ", columnNames=" + String.valueOf(this.columnNames) + "}";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof WithQuery)) return false;
        WithQuery that = (WithQuery)o;
        if (!this.name.equals(that.name)) return false;
        if (!this.query.equals(that.query)) return false;
        if (!Objects.equals(this.columnNames, that.columnNames)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.columnNames);
    }
}

