/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import com.microsoft.azure.storage.LocationMode;
import com.microsoft.azure.storage.StorageException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetadata;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.repositories.azure.AzureBlobContainer;
import org.elasticsearch.repositories.azure.AzureRepository;
import org.elasticsearch.repositories.azure.AzureStorageService;
import org.elasticsearch.repositories.azure.AzureStorageSettings;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class AzureBlobStore
implements BlobStore {
    private final AzureStorageService service;
    private final String container;
    private final LocationMode locationMode;

    public AzureBlobStore(RepositoryMetadata metadata) {
        this(metadata, new AzureStorageService(AzureStorageSettings.getClientSettings(metadata.settings())));
    }

    @VisibleForTesting
    AzureBlobStore(RepositoryMetadata metadata, AzureStorageService service) {
        this.container = (String)AzureRepository.Repository.CONTAINER_SETTING.get(metadata.settings());
        this.locationMode = (LocationMode)AzureRepository.Repository.LOCATION_MODE_SETTING.get(metadata.settings());
        this.service = service;
        this.service.refreshSettings(service.storageSettings);
    }

    public String toString() {
        return this.container;
    }

    public LocationMode getLocationMode() {
        return this.locationMode;
    }

    public BlobContainer blobContainer(BlobPath path) {
        return new AzureBlobContainer(path, this);
    }

    public void close() {
    }

    public boolean blobExists(String blob) throws URISyntaxException, StorageException {
        return this.service.blobExists(this.container, blob);
    }

    public void deleteBlob(String blob) throws URISyntaxException, StorageException {
        this.service.deleteBlob(this.container, blob);
    }

    public void deleteBlobDirectory(String keyPath) throws URISyntaxException, StorageException, IOException {
        this.service.deleteBlobDirectory(this.container, keyPath);
    }

    public Map<String, BlobContainer> children(BlobPath path) throws URISyntaxException, StorageException {
        return Collections.unmodifiableMap(this.service.children(this.container, path).stream().collect(Collectors.toMap(Function.identity(), name -> new AzureBlobContainer(path.add(name), this))));
    }

    public InputStream getInputStream(String blob, long position, @Nullable Long length) throws URISyntaxException, StorageException, IOException {
        return this.service.getInputStream(this.container, blob, position, length);
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(String keyPath, String prefix) throws URISyntaxException, StorageException {
        return this.service.listBlobsByPrefix(this.container, keyPath, prefix);
    }

    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws URISyntaxException, StorageException, IOException {
        this.service.writeBlob(this.container, blobName, inputStream, blobSize, failIfAlreadyExists);
    }
}

