/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.yaml;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.yaml.YamlXContentGenerator;
import org.elasticsearch.common.xcontent.yaml.YamlXContentParser;
import org.jetbrains.annotations.Nullable;

public class YamlXContent
implements XContent {
    static final YAMLFactory YAML_FACTORY = ((YAMLFactoryBuilder)YAMLFactory.builder().configure(StreamReadFeature.STRICT_DUPLICATE_DETECTION, XContent.isStrictDuplicateDetectionEnabled())).build();
    public static final YamlXContent YAML_XCONTENT = new YamlXContent();

    public static XContentBuilder contentBuilder() throws IOException {
        return XContentBuilder.builder(YAML_XCONTENT);
    }

    private YamlXContent() {
    }

    @Override
    public XContentType type() {
        return XContentType.YAML;
    }

    @Override
    public byte streamSeparator() {
        throw new UnsupportedOperationException("yaml does not support stream parsing...");
    }

    @Override
    public XContentGenerator createGenerator(OutputStream os, @Nullable String rootValueSeparator) throws IOException {
        return new YamlXContentGenerator((JsonGenerator)YAML_FACTORY.createGenerator(os, JsonEncoding.UTF8), os);
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, String content) throws IOException {
        return new YamlXContentParser(xContentRegistry, deprecationHandler, (JsonParser)YAML_FACTORY.createParser((Reader)new StringReader(content)));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, InputStream is) throws IOException {
        return new YamlXContentParser(xContentRegistry, deprecationHandler, (JsonParser)YAML_FACTORY.createParser(is));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data) throws IOException {
        return new YamlXContentParser(xContentRegistry, deprecationHandler, (JsonParser)YAML_FACTORY.createParser(data));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data, int offset, int length) throws IOException {
        return new YamlXContentParser(xContentRegistry, deprecationHandler, (JsonParser)YAML_FACTORY.createParser(data, offset, length));
    }
}

