/*
 * Decompiled with CFR 0.152.
 */
package io.crate.copy.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import io.crate.copy.s3.common.S3ClientHelper;
import io.crate.copy.s3.common.S3URI;
import io.crate.execution.engine.collect.files.FileInput;
import io.crate.execution.engine.collect.files.Globs;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class S3FileInput
implements FileInput {
    private static final Pattern HAS_GLOBS_PATTERN = Pattern.compile("^((s3://)[^\\*]*/)[^\\*]*\\*.*");
    private AmazonS3 client;
    private static final Logger LOGGER = LogManager.getLogger(S3FileInput.class);
    private final S3ClientHelper clientBuilder;
    @NotNull
    private final S3URI normalizedS3URI;
    @Nullable
    private final S3URI preGlobUri;
    @NotNull
    private final Predicate<String> uriPredicate;
    @Nullable
    private final String protocolSetting;

    public S3FileInput(URI uri, String protocol) {
        this.clientBuilder = new S3ClientHelper();
        this.normalizedS3URI = S3URI.toS3URI(uri);
        this.preGlobUri = S3FileInput.toPreGlobUri(this.normalizedS3URI);
        this.uriPredicate = new Globs.GlobPredicate(this.normalizedS3URI.toString());
        this.protocolSetting = protocol;
    }

    @VisibleForTesting
    S3FileInput(S3ClientHelper clientBuilder, URI uri, String protocol) {
        this.clientBuilder = clientBuilder;
        this.normalizedS3URI = S3URI.toS3URI(uri);
        this.preGlobUri = S3FileInput.toPreGlobUri(this.normalizedS3URI);
        this.uriPredicate = new Globs.GlobPredicate(this.normalizedS3URI.toString());
        this.protocolSetting = protocol;
    }

    public boolean isGlobbed() {
        return this.preGlobUri != null;
    }

    public URI uri() {
        return this.normalizedS3URI.uri();
    }

    public List<URI> expandUri() throws IOException {
        if (!this.isGlobbed()) {
            return List.of(this.normalizedS3URI.uri());
        }
        if (this.client == null) {
            this.client = this.clientBuilder.client(this.preGlobUri, this.protocolSetting);
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        ObjectListing list = this.client.listObjects(this.preGlobUri.bucket(), this.preGlobUri.key());
        this.addKeyUris(uris, list);
        while (list.isTruncated()) {
            list = this.client.listNextBatchOfObjects(list);
            this.addKeyUris(uris, list);
        }
        return uris;
    }

    private void addKeyUris(List<URI> uris, ObjectListing list) {
        assert (this.preGlobUri != null);
        List summaries = list.getObjectSummaries();
        for (S3ObjectSummary summary : summaries) {
            S3URI keyUri;
            String key = summary.getKey();
            if (key.endsWith("/") || !this.uriPredicate.test((keyUri = this.preGlobUri.replacePath(summary.getBucketName(), key)).toString())) continue;
            uris.add(keyUri.uri());
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("{}", (Object)keyUri);
        }
    }

    public InputStream getStream(URI uri) throws IOException {
        S3Object object;
        S3URI s3URI = S3URI.toS3URI(uri);
        if (this.client == null) {
            this.client = this.clientBuilder.client(s3URI, this.protocolSetting);
        }
        if ((object = this.client.getObject(s3URI.bucket(), s3URI.key())) != null) {
            return object.getObjectContent();
        }
        throw new IOException("Failed to load S3 URI: " + uri.toString());
    }

    public boolean sharedStorageDefault() {
        return true;
    }

    @VisibleForTesting
    @Nullable
    static S3URI toPreGlobUri(S3URI uri) {
        Matcher hasGlobMatcher = HAS_GLOBS_PATTERN.matcher(uri.toString());
        S3URI preGlobUri = null;
        if (hasGlobMatcher.matches()) {
            preGlobUri = S3URI.toS3URI(URI.create(hasGlobMatcher.group(1)));
        }
        return preGlobUri;
    }
}

