/*
 * Decompiled with CFR 0.152.
 */
package io.crate.copy.s3.common;

import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.Locale;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public enum S3Protocol {
    HTTPS,
    HTTP;

    private static final String NAME = "protocol";
    private static final Setting<S3Protocol> PROTOCOL;

    public static String get(Settings settings) {
        return ((S3Protocol)((Object)PROTOCOL.get(settings))).toString();
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ENGLISH);
    }

    static {
        PROTOCOL = new Setting(NAME, HTTPS.toString(), p -> {
            for (S3Protocol s3Protocol : S3Protocol.values()) {
                if (!s3Protocol.toString().equals(p)) continue;
                return s3Protocol;
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "invalid protocol `%s`. Expected HTTP or HTTPS", p));
        }, (DataType)DataTypes.STRING, new Setting.Property[]{Setting.Property.Final});
    }
}

