/*
 * Decompiled with CFR 0.152.
 */
package io.crate.beans;

import com.carrotsearch.hppc.cursors.IntObjectCursor;
import io.crate.beans.NodeInfoMXBean;
import io.crate.beans.ShardInfo;
import io.crate.beans.ShardStats;
import io.crate.exceptions.RelationUnknown;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;

public class NodeInfo
implements NodeInfoMXBean {
    public static final String NAME = "io.crate.monitoring:type=NodeInfo";
    private final Supplier<ClusterState> clusterState;
    private final Function<ShardId, ShardStateStoreSize> getShardStateAndSize;

    public NodeInfo(Supplier<ClusterState> clusterState, Function<ShardId, ShardStateStoreSize> getShardStateAndSize) {
        this.clusterState = clusterState;
        this.getShardStateAndSize = getShardStateAndSize;
    }

    @Override
    public String getNodeId() {
        return this.clusterState.get().nodes().getLocalNodeId();
    }

    @Override
    public String getNodeName() {
        return this.clusterState.get().nodes().getLocalNode().getName();
    }

    @Override
    public long getClusterStateVersion() {
        return this.clusterState.get().version();
    }

    @Override
    public ShardStats getShardStats() {
        int total = 0;
        int replicas = 0;
        int unassigned = 0;
        int primaries = 0;
        ClusterState clusterState = this.clusterState.get();
        Metadata metadata = clusterState.metadata();
        String localNodeId = clusterState.nodes().getLocalNodeId();
        boolean isMasterNode = clusterState.nodes().isLocalNodeElectedMaster();
        for (IndexRoutingTable indexRoutingTable : clusterState.routingTable()) {
            Index index = indexRoutingTable.getIndex();
            IndexMetadata indexMetadata = metadata.index(index);
            if (indexRoutingTable == null || indexMetadata.getState() == IndexMetadata.State.CLOSE) continue;
            for (IntObjectCursor cursor : indexRoutingTable.shards()) {
                IndexShardRoutingTable indexShardRoutingTable = (IndexShardRoutingTable)cursor.value;
                for (ShardRouting shardRouting : indexShardRoutingTable.shards()) {
                    if (isMasterNode && shardRouting.unassigned()) {
                        ++unassigned;
                    }
                    if (!localNodeId.equals(shardRouting.currentNodeId())) continue;
                    ++total;
                    if (shardRouting.primary()) {
                        ++primaries;
                        continue;
                    }
                    ++replicas;
                }
            }
        }
        return new ShardStats(total, primaries, replicas, unassigned);
    }

    @Override
    public List<ShardInfo> getShardInfo() {
        ClusterState clusterState = this.clusterState.get();
        Metadata metadata = clusterState.metadata();
        String localNodeId = clusterState.nodes().getLocalNodeId();
        ArrayList<ShardInfo> result = new ArrayList<ShardInfo>();
        for (IndexRoutingTable indexRoutingTable : clusterState.routingTable()) {
            Index index = indexRoutingTable.getIndex();
            IndexMetadata indexMetadata = metadata.index(index);
            if (indexRoutingTable == null || indexMetadata.getState() == IndexMetadata.State.CLOSE) continue;
            for (IntObjectCursor cursor : indexRoutingTable.shards()) {
                IndexShardRoutingTable indexShardRoutingTable = (IndexShardRoutingTable)cursor.value;
                for (ShardRouting shardRouting : indexShardRoutingTable.shards()) {
                    PartitionName partitionName;
                    ShardId shardId;
                    ShardStateStoreSize stateAndStoreSize;
                    if (!localNodeId.equals(shardRouting.currentNodeId()) || (stateAndStoreSize = this.getShardStateAndSize.apply(shardId = shardRouting.shardId())) == null) continue;
                    try {
                        partitionName = clusterState.metadata().getPartitionName(shardId.getIndexUUID());
                    }
                    catch (RelationUnknown | IndexNotFoundException e) {
                        continue;
                    }
                    ShardRoutingState routingState = shardRouting.state();
                    RelationName relationName = partitionName.relationName();
                    result.add(new ShardInfo(shardId.id(), relationName.schema(), relationName.name(), partitionName.ident() == null ? "" : partitionName.ident(), routingState.name(), stateAndStoreSize.state().name(), stateAndStoreSize.storeSizeBytes()));
                }
            }
        }
        return result;
    }

    public record ShardStateStoreSize(IndexShardState state, long storeSizeBytes) {
    }

    public static class ShardStateAndSizeProvider
    implements Function<ShardId, ShardStateStoreSize> {
        private final IndicesService indicesService;

        public ShardStateAndSizeProvider(IndicesService indicesService) {
            this.indicesService = indicesService;
        }

        @Override
        public ShardStateStoreSize apply(ShardId shardId) {
            IndexShard shard = this.indicesService.getShardOrNull(shardId);
            if (shard == null) {
                return null;
            }
            return new ShardStateStoreSize(shard.state(), shard.storeStats().sizeInBytes());
        }
    }
}

