/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.collections;

import io.crate.common.collections.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;

public final class Iterables {
    private Iterables() {
    }

    public static <T> T getOnlyElement(Iterable<T> iterable) {
        return Iterators.getOnlyElement(iterable.iterator());
    }

    public static <T> T getFirst(Iterable<? extends T> iterable, @Nullable T defaultValue) {
        return Iterators.getNext(iterable.iterator(), defaultValue);
    }

    @Nullable
    public static <T> T getLast(Iterable<? extends T> iterable, @Nullable T defaultValue) {
        if (iterable instanceof Collection) {
            Collection c = (Collection)iterable;
            if (c.isEmpty()) {
                return defaultValue;
            }
            if (iterable instanceof List) {
                return Iterables.getLastInNonemptyList((List)iterable);
            }
        }
        return Iterators.getLast(iterable.iterator(), defaultValue);
    }

    public static <T> T getLast(Iterable<T> iterable) {
        if (iterable instanceof List) {
            List list = (List)iterable;
            if (list.isEmpty()) {
                throw new NoSuchElementException();
            }
            return Iterables.getLastInNonemptyList(list);
        }
        return Iterators.getLast(iterable.iterator());
    }

    private static <T> T getLastInNonemptyList(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> Iterable<T> concat(Iterable<? extends Iterable<? extends T>> inputs) {
        return FluentIterable.concat(inputs);
    }

    @SafeVarargs
    public static final <T> Iterable<T> concat(Iterable<? extends T> ... inputs) {
        return FluentIterable.concat(inputs);
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b) {
        return FluentIterable.concat(a, b);
    }

    public static <T> Iterable<List<T>> partition(Iterable<T> iterable, int size) {
        Objects.requireNonNull(iterable);
        assert (size > 0);
        return () -> Iterators.partition(iterable.iterator(), size);
    }

    public static <F, T> Iterable<T> transform(final Iterable<F> fromIterable, final Function<? super F, ? extends T> function) {
        Objects.requireNonNull(fromIterable);
        Objects.requireNonNull(function);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.transform(fromIterable.iterator(), function);
            }

            @Override
            public void forEach(Consumer<? super T> action) {
                Objects.requireNonNull(action);
                fromIterable.forEach(f -> action.accept((Object)function.apply(f)));
            }

            @Override
            public Spliterator<T> spliterator() {
                return Iterators.map(fromIterable.spliterator(), function);
            }
        };
    }

    public static <T> Iterable<T> mergeSorted(Iterable<? extends Iterable<? extends T>> iterables, Comparator<? super T> comparator) {
        Objects.requireNonNull(iterables, "iterables");
        Objects.requireNonNull(comparator, "comparator");
        return () -> Iterators.mergeSorted(Iterables.transform(iterables, Iterable::iterator), comparator);
    }

    public static <T> boolean addAll(Collection<T> addTo, Iterable<? extends T> elementsToAdd) {
        if (elementsToAdd instanceof Collection) {
            Collection c = (Collection)elementsToAdd;
            return addTo.addAll(c);
        }
        return Iterators.addAll(addTo, Objects.requireNonNull(elementsToAdd).iterator());
    }

    public static <T> Stream<T> sequentialStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    static abstract class FluentIterable<E>
    implements Iterable<E> {
        private final Optional<Iterable<E>> iterableDelegate;

        protected FluentIterable() {
            this.iterableDelegate = Optional.empty();
        }

        FluentIterable(Iterable<E> iterable) {
            Objects.requireNonNull(iterable);
            this.iterableDelegate = Optional.ofNullable(this != iterable ? iterable : null);
        }

        public static <T> FluentIterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b) {
            return FluentIterable.concatNoDefensiveCopy(a, b);
        }

        @SafeVarargs
        public static final <T> FluentIterable<T> concat(Iterable<? extends T> ... inputs) {
            return FluentIterable.concatNoDefensiveCopy(Arrays.copyOf(inputs, inputs.length));
        }

        public static <T> FluentIterable<T> concat(final Iterable<? extends Iterable<? extends T>> inputs) {
            Objects.requireNonNull(inputs);
            return new FluentIterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return Iterators.concat(Iterators.transform(inputs.iterator(), Iterable::iterator));
                }
            };
        }

        @SafeVarargs
        private static final <T> FluentIterable<T> concatNoDefensiveCopy(final Iterable<? extends T> ... inputs) {
            for (Iterable<? extends T> input : inputs) {
                Objects.requireNonNull(input);
            }
            return new FluentIterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return Iterators.concat(new Iterators.AbstractIndexedListIterator<Iterator<? extends T>>(this, inputs.length){

                        @Override
                        public Iterator<? extends T> get(int i) {
                            return inputs[i].iterator();
                        }
                    });
                }
            };
        }

        public String toString() {
            return this.iterableDelegate.toString();
        }
    }
}

