/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.concurrent;

import io.crate.common.concurrent.ExpAvgMeasurement;
import io.crate.common.concurrent.Measurement;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConcurrencyLimit {
    private static final Logger LOG = LogManager.getLogger(ConcurrencyLimit.class);
    private volatile double estimatedLimit;
    private long lastRtt;
    private final Measurement longRtt;
    private final int maxLimit;
    private final int minLimit;
    private final IntFunction<Integer> queueSize;
    private final double smoothing;
    private final double tolerance;
    private volatile int limit;
    private final AtomicInteger numInflight = new AtomicInteger();

    public ConcurrencyLimit(int initialLimit, int minConcurrency, int maxConcurrency, IntFunction<Integer> queueSize, double smoothing, int longWindow, double rttTolerance) {
        this.limit = initialLimit;
        this.estimatedLimit = initialLimit;
        this.minLimit = minConcurrency;
        this.maxLimit = maxConcurrency;
        this.queueSize = queueSize;
        this.smoothing = smoothing;
        this.tolerance = rttTolerance;
        this.lastRtt = 0L;
        this.longRtt = new ExpAvgMeasurement(longWindow, 10);
    }

    public long startSample() {
        this.numInflight.incrementAndGet();
        return System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSample(long startTime) {
        long rtt = System.nanoTime() - startTime;
        int decrementedNumInflight = this.numInflight.decrementAndGet();
        ConcurrencyLimit concurrencyLimit = this;
        synchronized (concurrencyLimit) {
            int newLimit = this.update(rtt, decrementedNumInflight);
            if (newLimit != this.limit) {
                this.limit = newLimit;
            }
        }
    }

    public final int getLimit() {
        return this.limit;
    }

    private int update(long rtt, int inflight) {
        double queueSize = this.queueSize.apply((int)this.estimatedLimit).intValue();
        this.lastRtt = rtt;
        double shortRtt = rtt;
        double longRtt = this.longRtt.add(rtt);
        if (longRtt / shortRtt > 2.0) {
            this.longRtt.update(current -> current * 0.95);
        }
        if ((double)inflight < this.estimatedLimit / 2.0) {
            return (int)this.estimatedLimit;
        }
        double gradient = Math.max(0.5, Math.min(1.0, this.tolerance * longRtt / shortRtt));
        double newLimit = this.estimatedLimit * gradient + queueSize;
        newLimit = this.estimatedLimit * (1.0 - this.smoothing) + newLimit * this.smoothing;
        if ((double)((int)this.estimatedLimit) != (newLimit = Math.max((double)this.minLimit, Math.min((double)this.maxLimit, newLimit)))) {
            LOG.debug("New limit={} lastRtt={} ms longRtt={} ms queueSize={} gradient={} inflight={}", (Object)((int)newLimit), (Object)((double)this.getLastRtt(TimeUnit.MICROSECONDS) / 1000.0), (Object)((double)this.getLongRtt(TimeUnit.MICROSECONDS) / 1000.0), (Object)queueSize, (Object)gradient, (Object)inflight);
        }
        this.estimatedLimit = newLimit;
        return (int)this.estimatedLimit;
    }

    public long getLastRtt(TimeUnit units) {
        return units.convert(this.lastRtt, TimeUnit.NANOSECONDS);
    }

    public long getLongRtt(TimeUnit units) {
        return units.convert((long)this.longRtt.get(), TimeUnit.NANOSECONDS);
    }

    public String toString() {
        return "GradientLimit [limit=" + (int)this.estimatedLimit + "]";
    }

    public boolean exceedsLimit() {
        return this.numInflight() > this.limit;
    }

    public int numInflight() {
        return this.numInflight.get();
    }
}

