/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.url;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.blobstore.url.URLBlobContainer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;

public class URLBlobStore
implements BlobStore {
    private final URL path;
    private final int bufferSizeInBytes;

    public URLBlobStore(Settings settings, URL path) {
        this.path = path;
        this.bufferSizeInBytes = (int)settings.getAsBytesSize("repositories.uri.buffer_size", new ByteSizeValue(100L, ByteSizeUnit.KB)).getBytes();
    }

    public String toString() {
        return this.path.toString();
    }

    public URL path() {
        return this.path;
    }

    public int bufferSizeInBytes() {
        return this.bufferSizeInBytes;
    }

    public BlobContainer blobContainer(BlobPath path) {
        try {
            return new URLBlobContainer(this, path, this.buildPath(path));
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new BlobStoreException("malformed URL " + String.valueOf(path), (Throwable)ex);
        }
    }

    public void close() {
    }

    private URL buildPath(BlobPath path) throws URISyntaxException, MalformedURLException {
        String[] paths = path.toArray();
        if (paths.length == 0) {
            return this.path();
        }
        URI blobPath = this.path.toURI().resolve(paths[0] + "/");
        if (paths.length > 1) {
            for (int i = 1; i < paths.length; ++i) {
                blobPath = blobPath.resolve(paths[i] + "/");
            }
        }
        return blobPath.toURL();
    }
}

