/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedAlterTableRenameColumn;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.expression.symbol.DynamicReference;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.AlterTableRenameColumn;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.QualifiedName;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlterTableRenameColumnAnalyzer {
    private final Schemas schemas;
    private final NodeContext nodeCtx;

    public AlterTableRenameColumnAnalyzer(Schemas schemas, NodeContext nodeCtx) {
        this.schemas = schemas;
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedAlterTableRenameColumn analyze(AlterTableRenameColumn<Expression> renameColumn, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        if (!renameColumn.table().partitionProperties().isEmpty()) {
            throw new UnsupportedOperationException("Renaming a column from a single partition is not supported");
        }
        CoordinatorSessionSettings sessionSettings = txnCtx.sessionSettings();
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.findRelation(renameColumn.table().getName(), Operation.ALTER, sessionSettings.sessionUser(), sessionSettings.searchPath());
        if (tableInfo.versionCreated().before(DocTableInfo.COLUMN_OID_VERSION)) {
            throw new UnsupportedOperationException("Renaming columns of a table created before version " + String.valueOf(DocTableInfo.COLUMN_OID_VERSION) + " is not supported");
        }
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, new FieldProviderResolvesUnknownColumns(tableInfo), null);
        ExpressionAnalysisContext expressionContext = new ExpressionAnalysisContext(sessionSettings);
        Reference sourceRef = (Reference)expressionAnalyzer.convert(renameColumn.column(), expressionContext);
        Reference targetRef = (Reference)expressionAnalyzer.convert(renameColumn.newName(), expressionContext);
        ColumnIdent sourceCol = sourceRef.column();
        ColumnIdent targetCol = targetRef.column();
        if (sourceCol.path().size() != targetCol.path().size()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot rename a column to a name that has different column level: %s, %s", sourceCol, targetCol));
        }
        if (!Objects.equals(sourceCol.getParent(), targetCol.getParent())) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "When renaming sub-columns, parent names must be equal: %s, %s", sourceCol.getParent(), targetCol.getParent()));
        }
        tableInfo.renameColumn(sourceRef, targetCol);
        return new AnalyzedAlterTableRenameColumn(tableInfo.ident(), sourceRef, targetCol);
    }

    public static class FieldProviderResolvesUnknownColumns
    implements FieldProvider<Reference> {
        private final DocTableInfo table;

        public FieldProviderResolvesUnknownColumns(DocTableInfo table) {
            this.table = table;
        }

        @Override
        @NotNull
        public Reference resolveField(QualifiedName qualifiedName, @Nullable List<String> path, Operation operation, boolean errorOnUnknownObjectKey) {
            ColumnIdent columnIdent = ColumnIdent.fromNameSafe(qualifiedName, path);
            Reference reference = this.table.getReference(columnIdent);
            if (reference == null && (reference = this.table.indexColumn(columnIdent)) == null) {
                return new DynamicReference(new ReferenceIdent(this.table.ident(), columnIdent), RowGranularity.DOC, -1);
            }
            return reference;
        }
    }
}

