/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedCopyFrom;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.exceptions.AmbiguousColumnException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Table;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnalyzedCopyFromReturnSummary
extends AnalyzedCopyFrom
implements AnalyzedRelation {
    private final List<ScopedSymbol> fields;

    AnalyzedCopyFromReturnSummary(DocTableInfo tableInfo, List<String> targetColumns, Table<Symbol> table, GenericProperties<Symbol> properties, Symbol uri) {
        super(tableInfo, targetColumns, table, properties, uri);
        this.fields = List.of(new ScopedSymbol(tableInfo.ident(), ColumnIdent.of("node"), ObjectType.of(ColumnPolicy.DYNAMIC).setInnerType("id", DataTypes.STRING).setInnerType("name", DataTypes.STRING).build()), new ScopedSymbol(tableInfo.ident(), ColumnIdent.of("uri"), DataTypes.STRING), new ScopedSymbol(tableInfo.ident(), ColumnIdent.of("success_count"), DataTypes.LONG), new ScopedSymbol(tableInfo.ident(), ColumnIdent.of("error_count"), DataTypes.LONG), new ScopedSymbol(tableInfo.ident(), ColumnIdent.of("errors"), DataTypes.UNTYPED_OBJECT));
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " is virtual relation, visiting it is unsupported");
    }

    @Override
    public Symbol getField(ColumnIdent column, Operation operation, boolean errorOnUnknownObjectKey) throws AmbiguousColumnException, ColumnUnknownException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot use getField on " + this.getClass().getSimpleName());
    }

    @Override
    public RelationName relationName() {
        return this.tableInfo().ident();
    }

    @Override
    @NotNull
    public List<Symbol> outputs() {
        return List.copyOf(this.fields);
    }
}

