/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.DDLStatement;
import io.crate.expression.symbol.Symbol;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Table;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class AnalyzedRestoreSnapshot
implements DDLStatement {
    private final String repository;
    private final String snapshot;
    private final List<Table<Symbol>> tables;
    private final boolean includeTables;
    private final boolean includeCustomMetadata;
    private final Set<String> customMetadataTypes;
    private final boolean includeGlobalSettings;
    private final List<String> globalSettings;
    private final GenericProperties<Symbol> properties;

    AnalyzedRestoreSnapshot(String repository, String snapshot, List<Table<Symbol>> tables, boolean includeTables, boolean includeCustomMetadata, Set<String> customMetadataTypes, boolean includeGlobalSettings, List<String> globalSettings, GenericProperties<Symbol> properties) {
        this.repository = repository;
        this.snapshot = snapshot;
        this.tables = tables;
        this.includeTables = includeTables;
        this.includeCustomMetadata = includeCustomMetadata;
        this.customMetadataTypes = customMetadataTypes;
        this.includeGlobalSettings = includeGlobalSettings;
        this.globalSettings = globalSettings;
        this.properties = properties;
    }

    public String repository() {
        return this.repository;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public List<Table<Symbol>> tables() {
        return this.tables;
    }

    public boolean includeTables() {
        return this.includeTables;
    }

    public boolean includeCustomMetadata() {
        return this.includeCustomMetadata;
    }

    public Set<String> customMetadataTypes() {
        return this.customMetadataTypes;
    }

    public boolean includeGlobalSettings() {
        return this.includeGlobalSettings;
    }

    public List<String> globalSettings() {
        return this.globalSettings;
    }

    public GenericProperties<Symbol> properties() {
        return this.properties;
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (Table<Symbol> table : this.tables) {
            for (Assignment partitionProperty : table.partitionProperties()) {
                partitionProperty.expressions().forEach(consumer);
            }
        }
        this.properties.forValues(consumer);
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> visitor, C context) {
        return visitor.visitRestoreSnapshotAnalyzedStatement(this, context);
    }
}

