/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import com.carrotsearch.hppc.IntArrayList;
import io.crate.analyze.AnalyzedCheck;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public record BoundCreateTable(RelationName tableName, @Nullable String pkConstraintName, boolean ifNotExists, Map<ColumnIdent, Reference> columns, Settings settings, List<Reference> primaryKeys, Map<String, AnalyzedCheck> checks, ColumnIdent routingColumn, List<Reference> partitionedBy) {
    public boolean isPartitioned() {
        return !this.partitionedBy.isEmpty();
    }

    @Nullable
    public String templateName() {
        return this.partitionedBy.isEmpty() ? null : PartitionName.templateName(this.tableName.schema(), this.tableName.name());
    }

    public String templatePrefix() {
        return this.partitionedBy.isEmpty() ? null : PartitionName.templatePrefix(this.tableName.schema(), this.tableName.name());
    }

    public Map<String, String> getCheckConstraints() {
        LinkedHashMap<String, String> checksMapping = new LinkedHashMap<String, String>();
        for (Map.Entry<String, AnalyzedCheck> entry : this.checks.entrySet()) {
            String constraintName = entry.getKey();
            AnalyzedCheck analyzedCheck = entry.getValue();
            checksMapping.put(constraintName, analyzedCheck.expression());
        }
        return checksMapping;
    }

    public IntArrayList primaryKeysIndices() {
        IntArrayList pkKeyIndices = new IntArrayList(this.primaryKeys.size());
        for (Reference pk : this.primaryKeys) {
            int idx = Reference.indexOf(this.columns.values(), pk.column());
            pkKeyIndices.add(idx);
        }
        return pkKeyIndices;
    }
}

