/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedCreateTable;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.TableElementsAnalyzer;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.sql.tree.CreateTable;
import io.crate.sql.tree.Expression;

public final class CreateTableStatementAnalyzer {
    private final NodeContext nodeCtx;

    public CreateTableStatementAnalyzer(NodeContext nodeCtx) {
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedCreateTable analyze(CreateTable<Expression> createTable, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        RelationName relationName = RelationName.of(createTable.name().getName(), txnCtx.sessionSettings().searchPath().currentSchema());
        relationName.ensureValidForRelationCreation();
        TableElementsAnalyzer tableElementsAnalyzer = new TableElementsAnalyzer(relationName, txnCtx, this.nodeCtx, paramTypeHints);
        return tableElementsAnalyzer.analyze(createTable);
    }
}

