/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedDeleteStatement;
import io.crate.analyze.MaybeAliasedStatement;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.expressions.SubqueryAnalyzer;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.relations.FullQualifiedNameFieldProvider;
import io.crate.analyze.relations.RelationAnalysisContext;
import io.crate.analyze.relations.RelationAnalyzer;
import io.crate.analyze.relations.StatementAnalysisContext;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.Delete;
import io.crate.sql.tree.Node;
import java.util.Objects;

final class DeleteAnalyzer {
    private final NodeContext nodeCtx;
    private final RelationAnalyzer relationAnalyzer;

    DeleteAnalyzer(NodeContext nodeCtx, RelationAnalyzer relationAnalyzer) {
        this.nodeCtx = nodeCtx;
        this.relationAnalyzer = relationAnalyzer;
    }

    public AnalyzedDeleteStatement analyze(Delete delete, ParamTypeHints typeHints, CoordinatorTxnCtx txnContext) {
        StatementAnalysisContext stmtCtx = new StatementAnalysisContext(typeHints, Operation.DELETE, txnContext);
        RelationAnalysisContext relationCtx = stmtCtx.startRelation();
        AnalyzedRelation relation = this.relationAnalyzer.analyze((Node)delete.getRelation(), stmtCtx);
        stmtCtx.endRelation();
        MaybeAliasedStatement maybeAliasedStatement = MaybeAliasedStatement.analyze(relation);
        relation = maybeAliasedStatement.nonAliasedRelation();
        if (!(relation instanceof DocTableRelation)) {
            throw new UnsupportedOperationException("Cannot delete from relations other than base tables");
        }
        DocTableRelation table = (DocTableRelation)relation;
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(this.nodeCtx, RowGranularity.CLUSTER, null, table, f -> f.signature().isDeterministic());
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(txnContext, this.nodeCtx, typeHints, new FullQualifiedNameFieldProvider(relationCtx.sources(), relationCtx.parentSources(), txnContext.sessionSettings().searchPath().currentSchema()), new SubqueryAnalyzer(this.relationAnalyzer, new StatementAnalysisContext(typeHints, Operation.READ, txnContext)));
        Symbol query = Objects.requireNonNullElse(expressionAnalyzer.generateQuerySymbol(delete.getWhere(), new ExpressionAnalysisContext(txnContext.sessionSettings())), Literal.BOOLEAN_TRUE);
        query = maybeAliasedStatement.maybeMapFields(query);
        Symbol normalizedQuery = normalizer.normalize(query, txnContext);
        return new AnalyzedDeleteStatement(table, normalizedQuery);
    }
}

