/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedDropSnapshot;
import io.crate.execution.ddl.RepositoryService;
import io.crate.sql.tree.DropSnapshot;
import java.util.List;
import org.elasticsearch.common.inject.Singleton;

@Singleton
class DropSnapshotAnalyzer {
    private final RepositoryService repositoryService;

    DropSnapshotAnalyzer(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public AnalyzedDropSnapshot analyze(DropSnapshot node) {
        List parts = node.name().getParts();
        if (parts.size() != 2) {
            throw new IllegalArgumentException("Snapshot name not supported, only <repository>.<snapshot> works.");
        }
        String repositoryName = (String)parts.get(0);
        this.repositoryService.failIfRepositoryDoesNotExist(repositoryName);
        return new AnalyzedDropSnapshot(repositoryName, (String)parts.get(1));
    }
}

