/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.common.collections.Lists;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.doc.SysColumns;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Id {
    private static final Function<List<String>, String> RANDOM_ID = ignored -> UUIDs.base64UUID();
    private static final Function<List<String>, String> ONLY_ITEM_NULL_VALIDATION = keyValues -> Id.ensureNonNull((String)Lists.getOnlyElement((List)keyValues));
    private static final Function<List<String>, String> ONLY_ITEM = Lists::getOnlyElement;

    private static Function<List<String>, String> compileWithNullValidation(int numPks, int clusteredByPosition) {
        return switch (numPks) {
            case 0 -> RANDOM_ID;
            case 1 -> ONLY_ITEM_NULL_VALIDATION;
            default -> keyValues -> {
                if (keyValues.size() != numPks) {
                    throw new IllegalArgumentException("Missing primary key values");
                }
                return Id.encode(keyValues, clusteredByPosition);
            };
        };
    }

    public static Function<List<String>, String> compile(int numPks, int clusteredByPosition) {
        if (numPks == 1) {
            return ONLY_ITEM;
        }
        return Id.compileWithNullValidation(numPks, clusteredByPosition);
    }

    public static Function<List<String>, String> compileWithNullValidation(List<ColumnIdent> pkColumns, ColumnIdent clusteredBy) {
        int numPks = pkColumns.size();
        if (numPks == 1 && ((ColumnIdent)Lists.getOnlyElement(pkColumns)).equals(SysColumns.ID.COLUMN)) {
            return RANDOM_ID;
        }
        int idx = -1;
        if (clusteredBy != null) {
            idx = pkColumns.indexOf(clusteredBy);
        }
        return Id.compileWithNullValidation(numPks, idx);
    }

    @NotNull
    private static <T> T ensureNonNull(@Nullable T pkValue) throws IllegalArgumentException {
        if (pkValue == null) {
            throw new IllegalArgumentException("A primary key value must not be NULL");
        }
        return pkValue;
    }

    public static List<String> decode(List<ColumnIdent> primaryKeys, String id) {
        if (primaryKeys.isEmpty() || primaryKeys.size() == 1) {
            return List.of(id);
        }
        ArrayList<String> pkValues = new ArrayList<String>();
        byte[] inputBytes = Base64.getDecoder().decode(id);
        try (StreamInput in = StreamInput.wrap(inputBytes);){
            int size = in.readVInt();
            assert (size == primaryKeys.size()) : "Encoded primary key values must match size of primaryKey column list";
            for (int i = 0; i < size; ++i) {
                BytesRef bytesRef = in.readBytesRef();
                pkValues.add(bytesRef.utf8ToString());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return pkValues;
    }

    public static String encode(List<String> values, int clusteredByPosition) {
        BytesStreamOutput out = new BytesStreamOutput(Id.estimateSize(values));
        try {
            int size = values.size();
            out.writeVInt(size);
            if (clusteredByPosition >= 0) {
                out.writeBytesRef(new BytesRef((CharSequence)Id.ensureNonNull(values.get(clusteredByPosition))));
            }
            for (int i = 0; i < size; ++i) {
                if (i == clusteredByPosition) continue;
                out.writeBytesRef(new BytesRef((CharSequence)Id.ensureNonNull(values.get(i))));
            }
            String string = Base64.getEncoder().encodeToString(BytesReference.toBytes(out.bytes()));
            out.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static int estimateSize(Iterable<String> values) {
        int expectedEncodedSize = 0;
        for (String value : values) {
            expectedEncodedSize += 5 + (value != null ? value.length() : 0);
        }
        return expectedEncodedSize;
    }
}

