/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.sql.ExpressionFormatter;
import io.crate.sql.tree.ArrayComparisonExpression;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.sql.tree.SubqueryExpression;
import io.crate.sql.tree.SubscriptExpression;
import java.util.List;
import java.util.NoSuchElementException;

public class OutputNameFormatter {
    private static final InnerOutputNameFormatter INSTANCE = new InnerOutputNameFormatter();

    public static String format(Expression expression) {
        return (String)expression.accept((AstVisitor)INSTANCE, null);
    }

    private static class InnerOutputNameFormatter
    extends ExpressionFormatter.Formatter {
        private InnerOutputNameFormatter() {
        }

        protected String visitQualifiedNameReference(QualifiedNameReference node, List<Expression> parameters) {
            List parts = node.getName().getParts();
            if (parts.isEmpty()) {
                throw new NoSuchElementException("Parts of QualifiedNameReference are empty: " + String.valueOf(node.getName()));
            }
            return (String)parts.get(parts.size() - 1);
        }

        protected String visitSubscriptExpression(SubscriptExpression node, List<Expression> parameters) {
            return (String)node.base().accept((AstVisitor)this, null) + "[" + (String)node.index().accept((AstVisitor)this, null) + "]";
        }

        public String visitArrayComparisonExpression(ArrayComparisonExpression node, List<Expression> parameters) {
            return (String)node.getLeft().accept((AstVisitor)this, null) + " " + node.getType().getValue() + " " + node.quantifier().name() + "(" + (String)node.getRight().accept((AstVisitor)this, null) + ")";
        }

        protected String visitSubqueryExpression(SubqueryExpression node, List<Expression> parameters) {
            return super.visitSubqueryExpression(node, parameters).replace("\n", "");
        }
    }
}

