/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.Relations;
import io.crate.common.collections.Lists;
import io.crate.expression.symbol.DefaultTraversalSymbolVisitor;
import io.crate.expression.symbol.ParameterSymbol;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.types.DataType;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.jetbrains.annotations.VisibleForTesting;

public class ParameterTypes
extends DefaultTraversalSymbolVisitor<Set<ParameterSymbol>, Void> {
    private static final ParameterTypes INSTANCE = new ParameterTypes();

    private ParameterTypes() {
    }

    @VisibleForTesting
    static List<DataType<?>> extract(Consumer<Consumer<? super Symbol>> consumer) {
        TreeSet<ParameterSymbol> parameterSymbols = new TreeSet<ParameterSymbol>(Comparator.comparing(ParameterSymbol::index));
        consumer.accept(symbol -> symbol.accept(INSTANCE, parameterSymbols));
        if (!parameterSymbols.isEmpty() && parameterSymbols.last().index() != parameterSymbols.size() - 1) {
            throw new IllegalStateException("The assembled list of ParameterSymbols is invalid. Missing parameters.");
        }
        return Lists.map(parameterSymbols, ParameterSymbol::getBoundType);
    }

    public static List<DataType<?>> extract(AnalyzedStatement statement) {
        return ParameterTypes.extract((Consumer<? super Symbol> consumer) -> Relations.traverseDeepSymbols(statement, consumer));
    }

    @Override
    public Void visitSelectSymbol(SelectSymbol selectSymbol, Set<ParameterSymbol> parameterSymbols) {
        Relations.traverseDeepSymbols(selectSymbol.relation(), symbol -> symbol.accept(this, parameterSymbols));
        return null;
    }

    @Override
    public Void visitParameterSymbol(ParameterSymbol parameterSymbol, Set<ParameterSymbol> parameterSymbols) {
        parameterSymbols.add(parameterSymbol);
        return null;
    }
}

