/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedPrivileges;
import io.crate.common.collections.Lists;
import io.crate.exceptions.OperationOnInaccessibleRelationException;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.SearchPath;
import io.crate.metadata.table.Operation;
import io.crate.role.GrantedRolesChange;
import io.crate.role.Permission;
import io.crate.role.Policy;
import io.crate.role.Privilege;
import io.crate.role.Role;
import io.crate.role.Securable;
import io.crate.sql.tree.DenyPrivilege;
import io.crate.sql.tree.GrantPrivilege;
import io.crate.sql.tree.PrivilegeStatement;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.RevokePrivilege;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class PrivilegesAnalyzer {
    private final Schemas schemas;
    private static final String ERROR_MESSAGE = "GRANT/DENY/REVOKE Privileges on information_schema is not supported";

    PrivilegesAnalyzer(Schemas schemas) {
        this.schemas = schemas;
    }

    @NotNull
    public AnalyzedPrivileges analyze(PrivilegeStatement node, Role grantor, SearchPath searchPath) {
        PrivilegeStatement privilegeStatement = node;
        Objects.requireNonNull(privilegeStatement);
        PrivilegeStatement privilegeStatement2 = privilegeStatement;
        int n = 0;
        Policy policy = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GrantPrivilege.class, RevokePrivilege.class, DenyPrivilege.class}, (PrivilegeStatement)privilegeStatement2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> Policy.GRANT;
            case 1 -> Policy.REVOKE;
            case 2 -> Policy.DENY;
        };
        Securable securable = Securable.valueOf(node.securable());
        List<String> idents = this.validatePrivilegeIdents(grantor, securable, node.privilegeIdents(), policy == Policy.REVOKE, searchPath, this.schemas);
        if (securable == Securable.CLUSTER && !node.all()) {
            List<Permission> permissions = PrivilegesAnalyzer.parsePermissions(node.privileges(), false);
            if (!permissions.isEmpty()) {
                if (permissions.size() != node.privileges().size()) {
                    throw new IllegalArgumentException("Mixing up cluster privileges with roles is not allowed");
                }
                return AnalyzedPrivileges.ofPrivileges(node.userNames(), PrivilegesAnalyzer.permissionsToPrivileges(PrivilegesAnalyzer.getPermissions(node.all(), node.privileges()), grantor, policy, idents, securable));
            }
            if (policy == Policy.DENY) {
                throw new IllegalArgumentException("Cannot DENY a role");
            }
            if (node.userNames().contains(Role.CRATE_USER.name())) {
                throw new IllegalArgumentException("Cannot grant roles to " + Role.CRATE_USER.name() + " superuser");
            }
            if (node.privileges().contains(Role.CRATE_USER.name())) {
                throw new IllegalArgumentException("Cannot grant " + Role.CRATE_USER.name() + " superuser, to other users or roles");
            }
            for (String grantee : node.userNames()) {
                for (String roleNameToGrant : node.privileges()) {
                    if (!roleNameToGrant.equals(grantee)) continue;
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot grant role %s to itself as a cycle will be created", grantee));
                }
            }
            return AnalyzedPrivileges.ofRolePrivileges(node.userNames(), new GrantedRolesChange(policy, new HashSet<String>(node.privileges()), grantor.name()));
        }
        return AnalyzedPrivileges.ofPrivileges(node.userNames(), PrivilegesAnalyzer.permissionsToPrivileges(PrivilegesAnalyzer.getPermissions(node.all(), node.privileges()), grantor, policy, idents, securable));
    }

    private static Collection<Permission> getPermissions(boolean all, List<String> permissionNames) {
        return all ? Permission.VALUES : PrivilegesAnalyzer.parsePermissions(permissionNames, true);
    }

    private static void validateSchemaNames(List<String> schemaNames) {
        schemaNames.forEach(PrivilegesAnalyzer::validateSchemaName);
    }

    private static void validateSchemaName(String schemaName) {
        if ("information_schema".equals(schemaName)) {
            throw new UnsupportedFeatureException(ERROR_MESSAGE);
        }
    }

    private List<String> validatePrivilegeIdents(Role sessionUser, Securable securable, List<QualifiedName> tableOrSchemaNames, boolean isRevoke, SearchPath searchPath, Schemas schemas) {
        if (Securable.SCHEMA.equals((Object)securable)) {
            List schemaNames = Lists.map(tableOrSchemaNames, QualifiedName::toString);
            if (isRevoke) {
                return schemaNames;
            }
            PrivilegesAnalyzer.validateSchemaNames(schemaNames);
            return schemaNames;
        }
        return PrivilegesAnalyzer.resolveAndValidateRelations(tableOrSchemaNames, securable, sessionUser, searchPath, schemas, isRevoke);
    }

    private static List<Permission> parsePermissions(List<String> permissionNames, boolean validate) {
        ArrayList<Permission> permissions = new ArrayList<Permission>(permissionNames.size());
        for (String permissionName : permissionNames) {
            try {
                Permission permission = Permission.valueOf(permissionName.toUpperCase(Locale.ENGLISH));
                permissions.add(permission);
            }
            catch (IllegalArgumentException e) {
                if (!validate) continue;
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unknown permission '%s'", permissionName));
            }
        }
        return permissions;
    }

    private static Set<Privilege> permissionsToPrivileges(Collection<Permission> permissions, Role grantor, Policy policy, List<String> idents, Securable securable) {
        HashSet<Privilege> privileges = new HashSet<Privilege>(permissions.size());
        if (Securable.CLUSTER.equals((Object)securable)) {
            for (Permission permission : permissions) {
                Privilege privilege = new Privilege(policy, permission, securable, null, grantor.name());
                privileges.add(privilege);
            }
        } else {
            for (Permission permission : permissions) {
                for (String ident : idents) {
                    Privilege privilege = new Privilege(policy, permission, securable, ident, grantor.name());
                    privileges.add(privilege);
                }
            }
        }
        return privileges;
    }

    private static List<String> resolveAndValidateRelations(List<QualifiedName> relations, Securable securable, Role sessionUser, SearchPath searchPath, Schemas schemas, boolean isRevoke) {
        return Lists.map(relations, q -> {
            try {
                Securable actualSecurable;
                Object relation = schemas.findRelation((QualifiedName)q, Operation.READ, sessionUser, searchPath);
                switch (relation.relationType()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FOREIGN: 
                    case BASE_TABLE: {
                        Securable securable2 = Securable.TABLE;
                        break;
                    }
                    case VIEW: {
                        Securable securable2 = actualSecurable = Securable.VIEW;
                    }
                }
                if (securable != actualSecurable) {
                    throw new OperationOnInaccessibleRelationException(relation.ident(), String.format(Locale.ENGLISH, "Expected %s to be a %s securable but got a relation of type %s", new Object[]{relation.ident(), securable, relation.relationType()}));
                }
                RelationName relationName = relation.ident();
                if (!isRevoke) {
                    PrivilegesAnalyzer.validateSchemaName(relationName.schema());
                }
                return relationName.fqn();
            }
            catch (RelationUnknown e) {
                if (!isRevoke) {
                    throw e;
                }
                return RelationName.of(q, searchPath.currentSchema()).fqn();
            }
        });
    }
}

