/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.JoinRelation;
import io.crate.analyze.QueriedSelectRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.analyze.relations.AnalyzedView;
import io.crate.analyze.relations.TableFunctionRelation;
import io.crate.analyze.relations.UnionSelect;
import io.crate.expression.symbol.Symbol;
import java.util.function.Consumer;

public class Relations {
    public static void traverseDeepSymbols(AnalyzedStatement stmt, Consumer<? super Symbol> consumer) {
        TraverseDeepSymbolsStatements.traverse(stmt, consumer);
    }

    private static class TraverseDeepSymbolsStatements
    extends AnalyzedStatementVisitor<Consumer<? super Symbol>, Void> {
        private static final TraverseDeepSymbolsStatements INSTANCE = new TraverseDeepSymbolsStatements();

        private TraverseDeepSymbolsStatements() {
        }

        static void traverse(AnalyzedStatement stmt, Consumer<? super Symbol> consumer) {
            stmt.accept(INSTANCE, consumer);
        }

        @Override
        public Void visitSelectStatement(AnalyzedRelation relation, Consumer<? super Symbol> consumer) {
            TraverseDeepSymbolsRelations.traverse(relation, consumer);
            return null;
        }

        @Override
        protected Void visitAnalyzedStatement(AnalyzedStatement analyzedStatement, Consumer<? super Symbol> consumer) {
            analyzedStatement.visitSymbols(consumer);
            return null;
        }
    }

    private static class TraverseDeepSymbolsRelations
    extends AnalyzedRelationVisitor<Consumer<? super Symbol>, Void> {
        private static final TraverseDeepSymbolsRelations INSTANCE = new TraverseDeepSymbolsRelations();

        private TraverseDeepSymbolsRelations() {
        }

        static void traverse(AnalyzedRelation relation, Consumer<? super Symbol> consumer) {
            relation.accept(INSTANCE, consumer);
        }

        @Override
        protected Void visitAnalyzedRelation(AnalyzedRelation relation, Consumer<? super Symbol> context) {
            return null;
        }

        @Override
        public Void visitUnionSelect(UnionSelect unionSelect, Consumer<? super Symbol> consumer) {
            unionSelect.visitSymbols(consumer);
            return (Void)super.visitUnionSelect(unionSelect, consumer);
        }

        @Override
        public Void visitTableFunctionRelation(TableFunctionRelation tableFunctionRelation, Consumer<? super Symbol> consumer) {
            for (Symbol argument : tableFunctionRelation.function().arguments()) {
                consumer.accept(argument);
            }
            return null;
        }

        @Override
        public Void visitQueriedSelectRelation(QueriedSelectRelation relation, Consumer<? super Symbol> consumer) {
            relation.visitSymbols(consumer);
            return (Void)super.visitQueriedSelectRelation(relation, consumer);
        }

        @Override
        public Void visitJoinRelation(JoinRelation joinRelation, Consumer<? super Symbol> consumer) {
            joinRelation.visitSymbols(consumer);
            return (Void)super.visitJoinRelation(joinRelation, consumer);
        }

        @Override
        public Void visitView(AnalyzedView analyzedView, Consumer<? super Symbol> consumer) {
            analyzedView.visitSymbols(consumer);
            return (Void)super.visitView(analyzedView, consumer);
        }
    }
}

