/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedRestoreSnapshot;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.common.collections.Lists;
import io.crate.execution.ddl.RepositoryService;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.RestoreSnapshot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.common.logging.DeprecationLogger;

class RestoreSnapshotAnalyzer {
    static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(RestoreSnapshotAnalyzer.class));
    public static final List<String> USER_MANAGEMENT_METADATA = List.of("users", "roles", "users_privileges");
    public static final Map<String, List<String>> METADATA_CUSTOM_TYPE_MAP = Map.of("VIEWS", List.of("views"), "UDFS", List.of("user_defined_functions"), "USERS", USER_MANAGEMENT_METADATA, "PRIVILEGES", USER_MANAGEMENT_METADATA, "USERMANAGEMENT", USER_MANAGEMENT_METADATA);
    private final RepositoryService repositoryService;
    private final NodeContext nodeCtx;

    RestoreSnapshotAnalyzer(RepositoryService repositoryService, NodeContext nodeCtx) {
        this.repositoryService = repositoryService;
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedRestoreSnapshot analyze(RestoreSnapshot<Expression> restoreSnapshot, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        List nameParts = restoreSnapshot.name().getParts();
        if (nameParts.size() != 2) {
            throw new IllegalArgumentException("Snapshot name not supported, only <repository>.<snapshot> works.)");
        }
        String repositoryName = (String)nameParts.get(0);
        String snapshotName = (String)nameParts.get(1);
        this.repositoryService.failIfRepositoryDoesNotExist(repositoryName);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(txnCtx.sessionSettings());
        ExpressionAnalyzer exprAnalyzerWithoutFields = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.UNSUPPORTED, null);
        GenericProperties properties = restoreSnapshot.properties().map(x -> exprAnalyzerWithoutFields.convert((Expression)x, exprCtx));
        List tables = List.of();
        HashSet<String> customMetadataTypes = new HashSet<String>();
        ArrayList<String> globalSettings = new ArrayList<String>();
        boolean includeTables = false;
        boolean includeCustomMetadata = false;
        boolean includeGlobalSettings = false;
        switch (restoreSnapshot.mode()) {
            case ALL: {
                includeTables = true;
                includeCustomMetadata = true;
                includeGlobalSettings = true;
                break;
            }
            case METADATA: {
                includeCustomMetadata = true;
                includeGlobalSettings = true;
                globalSettings.add("crate.analysis.custom.");
                break;
            }
            case TABLE: {
                includeTables = true;
                ExpressionAnalyzer exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.TO_LITERAL_VALIDATE_NAME, null);
                tables = Lists.map((Collection)restoreSnapshot.tables(), table -> table.map(x -> exprAnalyzerWithFieldsAsString.convert((Expression)x, exprCtx)));
                break;
            }
            case CUSTOM: {
                for (String typeName : restoreSnapshot.types()) {
                    if ((typeName = typeName.toUpperCase(Locale.ENGLISH)).equals("TABLES")) {
                        includeTables = true;
                        continue;
                    }
                    if (typeName.equals("ANALYZERS")) {
                        globalSettings.add("crate.analysis.custom.");
                        includeGlobalSettings = true;
                        continue;
                    }
                    List<String> customTypes = METADATA_CUSTOM_TYPE_MAP.get(typeName);
                    if (customTypes == null) {
                        throw new IllegalArgumentException("Unknown metadata type '" + typeName + "'");
                    }
                    if ("USERS".equals(typeName) || "PRIVILEGES".equals(typeName)) {
                        DEPRECATION_LOGGER.deprecatedAndMaybeLog("restore_snapshot.metadata", typeName + " keyword is deprecated, please use USERMANAGEMENT instead", new Object[0]);
                    }
                    includeCustomMetadata = true;
                    customMetadataTypes.addAll(customTypes);
                }
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported restore mode='" + String.valueOf(restoreSnapshot.mode()) + "'"));
            }
        }
        return new AnalyzedRestoreSnapshot(repositoryName, snapshotName, tables, includeTables, includeCustomMetadata, customMetadataTypes, includeGlobalSettings, globalSettings, (GenericProperties<Symbol>)properties);
    }
}

