/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.data.Input;
import io.crate.exceptions.VersioningValidationException;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.PartitionName;
import io.crate.metadata.doc.SysColumns;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class WhereClause {
    public static final WhereClause MATCH_ALL = new WhereClause(null);
    public static final WhereClause NO_MATCH = new WhereClause(Literal.BOOLEAN_FALSE);
    @Nullable
    private final Symbol query;
    private final Set<Symbol> clusteredBy;
    private final List<PartitionName> partitions;

    public static boolean canMatch(Symbol query) {
        if (query instanceof Input) {
            Input input = (Input)query;
            return WhereClause.canMatch(input);
        }
        return true;
    }

    public static boolean canMatch(Input<?> input) {
        Object value = input.value();
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool;
        }
        throw new IllegalArgumentException("Expected query value to be of type `Boolean`, but got: " + String.valueOf(value));
    }

    public WhereClause(@Nullable Symbol query) {
        this.query = query;
        this.partitions = List.of();
        this.clusteredBy = Set.of();
    }

    public WhereClause(@Nullable Symbol normalizedQuery, @Nullable List<PartitionName> partitions, Set<Symbol> clusteredBy) {
        this.clusteredBy = clusteredBy;
        this.partitions = Objects.requireNonNullElse(partitions, List.of());
        this.query = normalizedQuery;
        if (normalizedQuery != null) {
            WhereClause.validateVersioningColumnsUsage(normalizedQuery);
        }
    }

    public boolean hasQuery() {
        return this.query != null;
    }

    @Nullable
    public Symbol query() {
        return this.query;
    }

    public Symbol queryOrFallback() {
        return this.query == null ? Literal.BOOLEAN_TRUE : this.query;
    }

    public static void validateVersioningColumnsUsage(Symbol query) {
        if (query.hasColumn(SysColumns.SEQ_NO)) {
            if (!query.hasColumn(SysColumns.PRIMARY_TERM)) {
                throw VersioningValidationException.seqNoAndPrimaryTermUsage();
            }
            if (query.hasColumn(SysColumns.VERSION)) {
                throw VersioningValidationException.mixedVersioningMeachanismsUsage();
            }
        } else if (query.hasColumn(SysColumns.PRIMARY_TERM)) {
            if (!query.hasColumn(SysColumns.SEQ_NO)) {
                throw VersioningValidationException.seqNoAndPrimaryTermUsage();
            }
            if (query.hasColumn(SysColumns.VERSION)) {
                throw VersioningValidationException.mixedVersioningMeachanismsUsage();
            }
        }
    }

    public Set<Symbol> clusteredBy() {
        return this.clusteredBy;
    }

    public Set<String> routingValues() {
        if (!this.clusteredBy.isEmpty()) {
            HashSet<String> result = HashSet.newHashSet(this.clusteredBy.size());
            for (Symbol symbol : this.clusteredBy) {
                assert (symbol instanceof Literal) : "clustered by symbols must be literals";
                result.add(((Literal)symbol).value().toString());
            }
            return result;
        }
        return Set.of();
    }

    public List<PartitionName> partitions() {
        return this.partitions;
    }

    public String toString() {
        return "WhereClause{clusteredBy=" + String.valueOf(this.clusteredBy) + ", partitions=" + String.valueOf(this.partitions) + ", query=" + String.valueOf(this.query) + "}";
    }

    public boolean hasVersions() {
        return this.query != null && this.query.hasColumn(SysColumns.VERSION);
    }

    public boolean hasSeqNoAndPrimaryTerm() {
        return this.query != null && this.query.hasColumn(SysColumns.SEQ_NO) && this.query.hasColumn(SysColumns.PRIMARY_TERM);
    }

    public WhereClause add(Symbol otherQuery) {
        if (this.query == null || this.query.equals(Literal.BOOLEAN_TRUE)) {
            return new WhereClause(otherQuery, this.partitions, this.clusteredBy);
        }
        if (WhereClause.canMatch(this.query)) {
            return new WhereClause(AndOperator.of(this.query, otherQuery), this.partitions, this.clusteredBy);
        }
        return this;
    }

    public WhereClause map(Function<? super Symbol, ? extends Symbol> mapper) {
        if (this.query == null && this.clusteredBy.isEmpty()) {
            return this;
        }
        Symbol newQuery = this.query == null ? null : mapper.apply(this.query);
        HashSet<Symbol> newClusteredBy = HashSet.newHashSet(this.clusteredBy.size());
        for (Symbol symbol : this.clusteredBy) {
            newClusteredBy.add(mapper.apply(symbol));
        }
        return new WhereClause(newQuery, this.partitions, newClusteredBy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhereClause that = (WhereClause)o;
        return Objects.equals(this.clusteredBy, that.clusteredBy) && Objects.equals(this.partitions, that.partitions);
    }

    public int hashCode() {
        return Objects.hash(this.clusteredBy, this.partitions);
    }
}

