/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.exceptions.AmbiguousColumnException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AnalyzedRelation
extends AnalyzedStatement {
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> var1, C var2);

    @Nullable
    public Symbol getField(ColumnIdent var1, Operation var2, boolean var3) throws AmbiguousColumnException, ColumnUnknownException, UnsupportedOperationException;

    @Nullable
    default public Symbol getField(ColumnIdent column, Operation operation) throws AmbiguousColumnException, ColumnUnknownException, UnsupportedOperationException {
        return this.getField(column, operation, true);
    }

    public RelationName relationName();

    @Override
    @NotNull
    public List<Symbol> outputs();

    default public List<Symbol> hiddenOutputs() {
        return List.of();
    }

    @Override
    default public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (Symbol output : this.outputs()) {
            consumer.accept(output);
        }
    }

    @Override
    default public <C, R> R accept(AnalyzedStatementVisitor<C, R> visitor, C context) {
        return visitor.visitSelectStatement(this, context);
    }

    @Override
    default public boolean isWriteOperation() {
        return false;
    }
}

