/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.FieldProvider;
import io.crate.analyze.relations.ParentRelations;
import io.crate.exceptions.AmbiguousColumnException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.exceptions.RelationUnknown;
import io.crate.expression.symbol.OuterColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.QualifiedName;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class FullQualifiedNameFieldProvider
implements FieldProvider<Symbol> {
    private final Map<RelationName, AnalyzedRelation> sources;
    private final ParentRelations parents;
    private final String defaultSchema;

    public FullQualifiedNameFieldProvider(Map<RelationName, AnalyzedRelation> sources, ParentRelations parents, String defaultSchema) {
        this.sources = Objects.requireNonNull(sources, "Please provide a source map.");
        this.parents = Objects.requireNonNull(parents, "ParentRelations must not be null");
        this.defaultSchema = Objects.requireNonNull(defaultSchema, "Default schema must not be null");
    }

    @Override
    public Symbol resolveField(QualifiedName qualifiedName, @Nullable List<String> path, Operation operation, boolean errorOnUnknownObjectKey) {
        RelationName relName;
        List parts = qualifiedName.getParts();
        String columnSchema = null;
        String columnTableName = null;
        ColumnIdent columnIdent = ColumnIdent.of((String)parts.get(parts.size() - 1), path);
        switch (parts.size()) {
            case 1: {
                break;
            }
            case 2: {
                columnTableName = (String)parts.get(0);
                break;
            }
            case 3: {
                columnSchema = (String)parts.get(0);
                columnTableName = (String)parts.get(1);
                break;
            }
            case 4: {
                RelationName.ensureIsCrateCatalog((String)parts.get(0));
                columnSchema = (String)parts.get(1);
                columnTableName = (String)parts.get(2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Column reference \"%s\" has too many parts. A column reference can have at most 3 parts and must have one of the following formats:  \"<column>\", \"<table>.<column>\" or \"<schema>.<table>.<column>\"");
            }
        }
        boolean schemaMatched = false;
        boolean tableNameMatched = false;
        Symbol lastField = null;
        ColumnUnknownException firstColUnknownException = null;
        for (Map.Entry<RelationName, AnalyzedRelation> entry : this.sources.entrySet()) {
            Symbol newField;
            block18: {
                relName = entry.getKey();
                if (columnSchema != null && !columnSchema.equals(relName.schema())) continue;
                schemaMatched = true;
                if (columnTableName != null && !relName.name().equals(columnTableName)) continue;
                tableNameMatched = true;
                AnalyzedRelation relation = entry.getValue();
                newField = null;
                try {
                    newField = relation.getField(columnIdent, operation, errorOnUnknownObjectKey);
                }
                catch (ColumnUnknownException e) {
                    if (firstColUnknownException != null) break block18;
                    firstColUnknownException = e;
                }
            }
            if (newField == null) continue;
            if (lastField != null) {
                if (!errorOnUnknownObjectKey) {
                    return this.resolveField(qualifiedName, path, operation, true);
                }
                throw new AmbiguousColumnException(columnIdent, newField);
            }
            lastField = newField;
        }
        if (lastField != null) {
            return lastField;
        }
        for (AnalyzedRelation relation : this.parents.getParents()) {
            relName = relation.relationName();
            if (columnSchema != null && !columnSchema.equals(relName.schema())) continue;
            schemaMatched = true;
            if (columnTableName != null && !relName.name().equals(columnTableName)) continue;
            tableNameMatched = true;
            Symbol newField = relation.getField(columnIdent, operation, errorOnUnknownObjectKey);
            if (newField == null) continue;
            if (lastField != null) {
                if (!errorOnUnknownObjectKey) {
                    return this.resolveField(qualifiedName, path, operation, true);
                }
                throw new AmbiguousColumnException(columnIdent, newField);
            }
            lastField = new OuterColumn(relation, newField);
        }
        if (lastField != null) {
            return lastField;
        }
        if (!schemaMatched || !tableNameMatched) {
            String schema = columnSchema == null ? this.defaultSchema : columnSchema;
            this.raiseUnsupportedFeatureIfInAncestorScope(columnSchema, columnTableName, schema);
            RelationName relationName = new RelationName(schema, columnTableName);
            throw new RelationUnknown(relationName);
        }
        RelationName relationName = this.sources.entrySet().iterator().next().getKey();
        if (firstColUnknownException == null) {
            firstColUnknownException = new ColumnUnknownException(columnIdent, relationName);
        }
        throw firstColUnknownException;
    }

    private void raiseUnsupportedFeatureIfInAncestorScope(String columnSchema, String columnTableName, String schema) {
        RelationName name = new RelationName(schema, columnTableName);
        if (this.parents.containsRelation(name)) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot use relation \"%s.%s\" in this context. Can only access columns of an immediate parent, not a grandparent", schema, columnTableName));
        }
        if (columnSchema == null && this.parents.containsRelation(new RelationName(null, columnTableName))) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot use relation \"%s\" in this context. Can only access columns of an immediate parent, not a grandparent", columnTableName));
        }
    }
}

