/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.metadata.RelationName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ParentRelations {
    public static final ParentRelations NO_PARENTS = new ParentRelations();
    private final List<Map<RelationName, AnalyzedRelation>> sourcesTree;

    private ParentRelations() {
        this.sourcesTree = Collections.emptyList();
    }

    private ParentRelations(ArrayList<Map<RelationName, AnalyzedRelation>> sourcesTree) {
        this.sourcesTree = sourcesTree;
    }

    public ParentRelations newLevel(Map<RelationName, AnalyzedRelation> sources) {
        ArrayList<Map<RelationName, AnalyzedRelation>> newSourcesTree = new ArrayList<Map<RelationName, AnalyzedRelation>>(this.sourcesTree);
        newSourcesTree.add(sources);
        return new ParentRelations(newSourcesTree);
    }

    public boolean containsRelation(RelationName qualifiedName) {
        return this.getAncestor(qualifiedName) != null;
    }

    @Nullable
    public AnalyzedRelation getParent(RelationName relationName) {
        if (this.sourcesTree.isEmpty() || this.sourcesTree.size() < 2) {
            return null;
        }
        Map<RelationName, AnalyzedRelation> parent = this.sourcesTree.get(this.sourcesTree.size() - 2);
        return parent.get(relationName);
    }

    public Iterable<AnalyzedRelation> getParents() {
        if (this.sourcesTree.isEmpty() || this.sourcesTree.size() < 2) {
            return Collections.emptyList();
        }
        return this.sourcesTree.get(this.sourcesTree.size() - 2).values();
    }

    @Nullable
    public AnalyzedRelation getAncestor(RelationName relationName) {
        AnalyzedRelation relation = null;
        for (int i = this.sourcesTree.size() - 1; i >= 0 && (relation = this.sourcesTree.get(i).get(relationName)) == null; --i) {
        }
        return relation;
    }
}

