/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.RelationNames;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.MatchPredicate;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.functions.Signature;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SequencedSet;
import java.util.Set;

public class QuerySplitter {
    private static final SplitVisitor SPLIT_VISITOR = new SplitVisitor();

    public static Map<Set<RelationName>, Symbol> split(Symbol query) {
        Context context = new Context(query);
        query.accept(SPLIT_VISITOR, context);
        return context.parts;
    }

    private static class Context {
        final Set<RelationName> allNames;
        final LinkedHashMap<Set<RelationName>, Symbol> parts;

        public Context(Symbol query) {
            this.allNames = RelationNames.getShallow(query);
            this.parts = new LinkedHashMap();
        }
    }

    private static class SplitVisitor
    extends SymbolVisitor<Context, Void> {
        private SplitVisitor() {
        }

        @Override
        public Void visitLiteral(Literal<?> literal, Context ctx) {
            ctx.parts.merge(ctx.allNames, literal, AndOperator::of);
            return null;
        }

        @Override
        public Void visitFunction(Function function, Context ctx) {
            Signature signature = function.signature();
            assert (signature != null) : "Expecting functions signature not to be null";
            if (!signature.equals(AndOperator.SIGNATURE)) {
                SequencedSet<RelationName> qualifiedNames = RelationNames.getShallow(function);
                ctx.parts.merge(qualifiedNames, function, AndOperator::of);
                return null;
            }
            for (Symbol arg : function.arguments()) {
                arg.accept(this, ctx);
            }
            return null;
        }

        @Override
        public Void visitField(ScopedSymbol field, Context ctx) {
            ctx.parts.merge(Set.of(field.relation()), field, AndOperator::of);
            return null;
        }

        @Override
        public Void visitReference(Reference ref, Context ctx) {
            ctx.parts.merge(Set.of(ref.ident().tableIdent()), ref, AndOperator::of);
            return null;
        }

        @Override
        public Void visitMatchPredicate(MatchPredicate matchPredicate, Context ctx) {
            LinkedHashSet<RelationName> relationNames = new LinkedHashSet<RelationName>();
            for (Symbol field : matchPredicate.identBoostMap().keySet()) {
                if (field instanceof ScopedSymbol) {
                    ScopedSymbol scopedSymbol = (ScopedSymbol)field;
                    relationNames.add(scopedSymbol.relation());
                    continue;
                }
                if (!(field instanceof Reference)) continue;
                Reference ref = (Reference)field;
                relationNames.add(ref.ident().tableIdent());
            }
            ctx.parts.merge(relationNames, matchPredicate, AndOperator::of);
            return null;
        }
    }
}

