/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.exceptions.AmbiguousColumnException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.UUIDs;
import org.jetbrains.annotations.NotNull;

public class UnionSelect
implements AnalyzedRelation {
    private final AnalyzedRelation left;
    private final AnalyzedRelation right;
    private final List<ScopedSymbol> outputs;
    private final RelationName name;
    private final boolean isDistinct;

    public UnionSelect(AnalyzedRelation left, AnalyzedRelation right, boolean isDistinct) {
        if (left.outputs().size() != right.outputs().size()) {
            throw new UnsupportedOperationException("Number of output columns must be the same for all parts of a UNION");
        }
        this.left = left;
        this.right = right;
        this.name = new RelationName(null, UUIDs.dirtyUUID().toString());
        List<Symbol> leftOutputs = left.outputs();
        List<Symbol> rightOutputs = right.outputs();
        ArrayList<ScopedSymbol> outputs = new ArrayList<ScopedSymbol>(leftOutputs.size());
        for (int i = 0; i < leftOutputs.size(); ++i) {
            Symbol l = leftOutputs.get(i);
            Symbol r = rightOutputs.get(i);
            try {
                outputs.add(new ScopedSymbol(this.name, l.toColumn(), DataTypes.merge(l.valueType(), r.valueType())));
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedOperationException("Output columns at position " + (i + 1) + " must be compatible for all parts of a UNION. Got `" + l.valueType().getName() + "` and `" + r.valueType().getName() + "`");
            }
        }
        this.outputs = List.copyOf(outputs);
        this.isDistinct = isDistinct;
    }

    public AnalyzedRelation left() {
        return this.left;
    }

    public AnalyzedRelation right() {
        return this.right;
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        return visitor.visitUnionSelect(this, context);
    }

    @Override
    public Symbol getField(ColumnIdent column, Operation operation, boolean errorOnUnknownObjectKey) throws AmbiguousColumnException, ColumnUnknownException, UnsupportedOperationException {
        ScopedSymbol field = null;
        for (ScopedSymbol output : this.outputs) {
            if (!output.column().equals(column)) continue;
            if (field != null) {
                throw new AmbiguousColumnException(output.column(), output);
            }
            field = output;
        }
        return field;
    }

    @Override
    public RelationName relationName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Symbol> outputs() {
        return this.outputs;
    }

    public String toString() {
        return String.valueOf(this.left) + " UNION " + (this.isDistinct ? "DISTINCT " : "ALL ") + String.valueOf(this.right);
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }
}

