/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.SigningKeyNotFoundException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class CachingJwkProvider
implements JwkProvider {
    private final URL url;
    private final ObjectReader reader;
    private final Clock clock;
    private volatile JwkResult cache;

    public CachingJwkProvider(String domain) {
        this(domain, Clock.systemUTC());
    }

    CachingJwkProvider(String domain, Clock clock) {
        this.url = CachingJwkProvider.urlForDomain(domain);
        this.clock = clock;
        this.reader = new ObjectMapper().readerFor(Map.class);
    }

    static URL urlForDomain(String domain) {
        if (Strings.isNullOrEmpty((CharSequence)domain)) {
            throw new IllegalArgumentException("A domain is required");
        }
        if (!((String)domain).startsWith("http")) {
            domain = "https://" + (String)domain;
        }
        try {
            URI uri = new URI((String)domain).normalize();
            return uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Invalid jwks uri", e);
        }
    }

    public Jwk get(String keyId) throws JwkException {
        Jwk jwk;
        JwkResult keys = this.cache;
        Instant now = this.clock.instant();
        if ((keys == null || keys.expired(now)) && !(keys = this.getKeys()).expired(now)) {
            this.cache = keys;
        }
        if ((jwk = keys.keys().get(keyId)) == null) {
            throw new SigningKeyNotFoundException("No key found in " + this.url.toString() + " with kid " + keyId, null);
        }
        return jwk;
    }

    private JwkResult getKeys() {
        Duration ttl;
        List keys;
        try {
            URLConnection c = this.url.openConnection();
            c.setRequestProperty("Accept", "application/json");
            try (InputStream inputStream = c.getInputStream();){
                Map result = (Map)this.reader.readValue(inputStream);
                keys = (List)result.get("keys");
                String cacheControl = c.getHeaderField(HttpHeaderNames.CACHE_CONTROL.toString());
                ttl = CachingJwkProvider.parseCacheControl(cacheControl);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot obtain jwks from url " + String.valueOf(this.url), e);
        }
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("No keys found in " + String.valueOf(this.url), null);
        }
        HashMap<String, Jwk> parsedKeys = HashMap.newHashMap(keys.size());
        for (Map key : keys) {
            Jwk jwk = Jwk.fromValues((Map)key);
            parsedKeys.put(jwk.getId(), jwk);
        }
        return new JwkResult(this.clock.instant().plus(ttl), parsedKeys);
    }

    @VisibleForTesting
    static Duration parseCacheControl(@Nullable String cacheControl) {
        if (cacheControl == null || !cacheControl.trim().startsWith("max-age=")) {
            return Duration.ZERO;
        }
        String maxAgeValue = cacheControl.substring(cacheControl.indexOf("=") + 1);
        try {
            int seconds = Integer.parseInt(maxAgeValue);
            return seconds > 0 ? Duration.ofSeconds(seconds) : Duration.ZERO;
        }
        catch (NumberFormatException ignored) {
            return Duration.ZERO;
        }
    }

    private record JwkResult(Instant expirationTime, Map<String, Jwk> keys) {
        public boolean expired(Instant now) {
            return now.compareTo(this.expirationTime) >= 0;
        }
    }
}

