/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob;

import io.crate.blob.BlobTransferStatus;
import io.crate.blob.BlobWriteException;
import io.crate.blob.DigestBlob;
import io.crate.blob.IPutChunkRequest;
import io.crate.blob.PutChunkReplicaRequest;
import io.crate.blob.PutChunkRequest;
import io.crate.blob.PutChunkResponse;
import io.crate.blob.RemoteDigestBlob;
import io.crate.blob.StartBlobRequest;
import io.crate.blob.StartBlobResponse;
import io.crate.blob.exceptions.BlobAlreadyExistsException;
import io.crate.blob.exceptions.DigestMismatchException;
import io.crate.blob.transfer.BlobInfoRequest;
import io.crate.blob.transfer.BlobTransferInfoResponse;
import io.crate.blob.transfer.GetBlobHeadRequest;
import io.crate.blob.v2.BlobIndicesService;
import io.crate.blob.v2.BlobShard;
import io.crate.common.unit.TimeValue;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.PlainFuture;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class BlobTransferTarget {
    private static final Logger LOGGER = LogManager.getLogger(BlobTransferTarget.class);
    private final ConcurrentMap<UUID, BlobTransferStatus> activeTransfers = new ConcurrentHashMap<UUID, BlobTransferStatus>();
    private final BlobIndicesService blobIndicesService;
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private CountDownLatch getHeadRequestLatch;
    private final CompletableFuture<CountDownLatch> getHeadRequestLatchFuture;
    private final ConcurrentLinkedQueue<UUID> activePutHeadChunkTransfers;
    private CountDownLatch activePutHeadChunkTransfersLatch;
    private volatile boolean recoveryActive = false;
    private final Object lock = new Object();
    private final List<UUID> finishedUploads = new ArrayList<UUID>();
    private final TimeValue STATE_REMOVAL_DELAY;

    public BlobTransferTarget(BlobIndicesService blobIndicesService, ThreadPool threadPool, TransportService transportService, ClusterService clusterService) {
        String property = System.getProperty("tests.short_timeouts");
        this.STATE_REMOVAL_DELAY = property == null ? new TimeValue(40L, TimeUnit.SECONDS) : new TimeValue(2L, TimeUnit.SECONDS);
        this.blobIndicesService = blobIndicesService;
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.getHeadRequestLatchFuture = new CompletableFuture();
        this.activePutHeadChunkTransfers = new ConcurrentLinkedQueue();
    }

    public BlobTransferStatus getActiveTransfer(UUID transferId) {
        return (BlobTransferStatus)this.activeTransfers.get(transferId);
    }

    public void startTransfer(StartBlobRequest request, StartBlobResponse response) {
        LOGGER.debug("startTransfer {} {}", (Object)request.transferId(), (Object)request.isLast());
        BlobShard blobShard = this.blobIndicesService.blobShardSafe(request.shardId());
        File existing = blobShard.blobContainer().getFile(request.id());
        long size = existing.length();
        if (existing.exists()) {
            response.status(RemoteDigestBlob.Status.EXISTS);
            response.size(size);
            return;
        }
        DigestBlob digestBlob = blobShard.blobContainer().createBlob(request.id(), request.transferId());
        digestBlob.addContent(request.content(), request.isLast());
        response.size(digestBlob.size());
        if (request.isLast()) {
            try {
                digestBlob.commit();
                blobShard.incrementStats(digestBlob.size());
                response.status(RemoteDigestBlob.Status.FULL);
            }
            catch (DigestMismatchException e) {
                response.status(RemoteDigestBlob.Status.MISMATCH);
            }
            catch (BlobAlreadyExistsException e) {
                response.size(digestBlob.size());
                response.status(RemoteDigestBlob.Status.EXISTS);
            }
            catch (Exception e) {
                response.status(RemoteDigestBlob.Status.FAILED);
            }
        } else {
            BlobTransferStatus status = new BlobTransferStatus(request.shardId(), request.transferId(), digestBlob);
            this.activeTransfers.put(request.transferId(), status);
            response.status(RemoteDigestBlob.Status.PARTIAL);
        }
        LOGGER.debug("startTransfer finished {} {}", (Object)response.status(), (Object)response.size());
    }

    public void continueTransfer(PutChunkReplicaRequest request, PutChunkResponse response) {
        BlobTransferStatus status = (BlobTransferStatus)this.activeTransfers.get(request.transferId);
        if (status == null) {
            status = this.restoreTransferStatus(request);
        }
        this.addContent(request, response, status);
    }

    public void continueTransfer(PutChunkRequest request, PutChunkResponse response) {
        BlobTransferStatus status = (BlobTransferStatus)this.activeTransfers.get(request.transferId());
        if (status == null) {
            LOGGER.error("No context for transfer: {} Dropping request", (Object)request.transferId());
            response.status(RemoteDigestBlob.Status.PARTIAL);
            return;
        }
        this.addContent(request, response, status);
    }

    private BlobTransferStatus restoreTransferStatus(PutChunkReplicaRequest request) {
        LOGGER.trace("Restoring transferContext for PutChunkReplicaRequest with transferId {}", (Object)request.transferId);
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        DiscoveryNode recipientNodeId = nodes.get(request.sourceNodeId);
        String senderNodeId = nodes.getLocalNodeId();
        PlainFuture listener = new PlainFuture();
        this.transportService.sendRequest(recipientNodeId, "internal:crate:blob/shard/tmp_transfer/get_info", new BlobInfoRequest(senderNodeId, request.transferId), new ActionListenerResponseHandler<BlobTransferInfoResponse>("internal:crate:blob/shard/tmp_transfer/get_info", listener, BlobTransferInfoResponse::new));
        BlobTransferInfoResponse transferInfoResponse = (BlobTransferInfoResponse)FutureUtils.get(listener);
        BlobShard blobShard = this.blobIndicesService.blobShardSafe(request.shardId());
        DigestBlob digestBlob = DigestBlob.resumeTransfer(blobShard.blobContainer(), transferInfoResponse.digest, request.transferId, request.currentPos);
        assert (digestBlob != null) : "DigestBlob couldn't be restored";
        BlobTransferStatus status = new BlobTransferStatus(request.shardId(), request.transferId, digestBlob);
        this.activeTransfers.put(request.transferId, status);
        LOGGER.trace("Restored transferStatus for digest {} transferId: {}", (Object)transferInfoResponse.digest, (Object)request.transferId);
        PlainFuture getBlobHeadListener = new PlainFuture();
        this.transportService.sendRequest(recipientNodeId, "internal:crate:blob/shard/tmp_transfer/get_head", new GetBlobHeadRequest(senderNodeId, request.transferId(), request.currentPos), new ActionListenerResponseHandler<TransportResponse.Empty>("internal:crate:blob/shard/tmp_transfer/get_head", getBlobHeadListener, streamInput -> TransportResponse.Empty.INSTANCE));
        FutureUtils.get(getBlobHeadListener);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addContent(IPutChunkRequest request, PutChunkResponse response, BlobTransferStatus status) {
        DigestBlob digestBlob = status.digestBlob();
        try {
            digestBlob.addContent(request.content(), request.isLast());
        }
        catch (BlobWriteException e) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{(Closeable)this.activeTransfers.remove(status.transferId())});
            throw e;
        }
        response.size(digestBlob.size());
        if (request.isLast()) {
            digestBlob.waitForHead();
            try {
                digestBlob.commit();
                BlobShard blobShard = this.blobIndicesService.blobShardSafe(status.shardId());
                blobShard.incrementStats(digestBlob.size());
                response.status(RemoteDigestBlob.Status.FULL);
            }
            catch (DigestMismatchException e) {
                response.status(RemoteDigestBlob.Status.MISMATCH);
            }
            catch (BlobAlreadyExistsException e) {
                response.size(digestBlob.size());
                response.status(RemoteDigestBlob.Status.EXISTS);
            }
            catch (Exception e) {
                response.status(RemoteDigestBlob.Status.FAILED);
            }
            finally {
                this.removeTransferAfterRecovery(status.transferId());
            }
            LOGGER.debug("transfer finished digest:{} status:{} size:{} chunks:{}", (Object)status.transferId(), (Object)response.status(), (Object)response.size(), (Object)digestBlob.chunks());
        } else {
            response.status(RemoteDigestBlob.Status.PARTIAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTransferAfterRecovery(UUID transferId) {
        boolean toSchedule = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.recoveryActive) {
                this.finishedUploads.add(transferId);
            } else {
                toSchedule = true;
            }
        }
        if (toSchedule) {
            LOGGER.debug("finished transfer {}, removing state", (Object)transferId);
            this.threadPool.schedule(new StateRemoval(transferId), this.STATE_REMOVAL_DELAY, "generic");
        }
    }

    public void createActiveTransfersSnapshot() {
        this.getHeadRequestLatch = new CountDownLatch(this.activeTransfers.size());
        this.getHeadRequestLatchFuture.complete(this.getHeadRequestLatch);
    }

    public void waitForGetHeadRequests(int num, TimeUnit timeUnit) {
        try {
            this.getHeadRequestLatch.await(num, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    public void waitUntilPutHeadChunksAreFinished() {
        try {
            this.activePutHeadChunkTransfersLatch.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    public void gotAGetBlobHeadRequest(UUID transferId) {
        if (this.getHeadRequestLatch == null) {
            try {
                this.getHeadRequestLatch = this.getHeadRequestLatchFuture.get();
                this.activePutHeadChunkTransfers.add(transferId);
                this.getHeadRequestLatch.countDown();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("can't retrieve getHeadRequestLatch", (Throwable)e);
            }
        }
    }

    public void createActivePutHeadChunkTransfersSnapshot() {
        this.activePutHeadChunkTransfersLatch = new CountDownLatch(this.activePutHeadChunkTransfers.size());
    }

    public void putHeadChunkTransferFinished(UUID transferId) {
        this.activePutHeadChunkTransfers.remove(transferId);
        if (this.activePutHeadChunkTransfersLatch != null) {
            this.activePutHeadChunkTransfersLatch.countDown();
        }
    }

    public void startRecovery() {
        this.recoveryActive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecovery() {
        Object object = this.lock;
        synchronized (object) {
            this.recoveryActive = false;
            for (UUID finishedUpload : this.finishedUploads) {
                LOGGER.debug("finished transfer and recovery for {}, removing state", (Object)finishedUpload);
                BlobTransferStatus transferStatus = (BlobTransferStatus)this.activeTransfers.remove(finishedUpload);
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{transferStatus});
            }
        }
    }

    private class StateRemoval
    implements Runnable {
        private final UUID transferId;

        private StateRemoval(UUID transferId) {
            this.transferId = transferId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = BlobTransferTarget.this.lock;
            synchronized (object) {
                if (BlobTransferTarget.this.recoveryActive) {
                    BlobTransferTarget.this.finishedUploads.add(this.transferId);
                } else {
                    BlobTransferStatus transferStatus = (BlobTransferStatus)BlobTransferTarget.this.activeTransfers.remove(this.transferId);
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{transferStatus});
                }
            }
        }
    }
}

