/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob;

import io.crate.blob.BlobTransferTarget;
import io.crate.blob.PutChunkReplicaRequest;
import io.crate.blob.PutChunkRequest;
import io.crate.blob.PutChunkResponse;
import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutChunk
extends TransportReplicationAction<PutChunkRequest, PutChunkReplicaRequest, PutChunkResponse> {
    public static final Action ACTION = new Action();
    private final BlobTransferTarget transferTarget;

    @Inject
    public TransportPutChunk(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, BlobTransferTarget transferTarget) {
        super(settings, ACTION.name(), transportService, clusterService, indicesService, threadPool, shardStateAction, PutChunkRequest::new, PutChunkReplicaRequest::new, "write");
        this.transferTarget = transferTarget;
    }

    @Override
    protected PutChunkResponse newResponseInstance(StreamInput in) throws IOException {
        return new PutChunkResponse(in);
    }

    @Override
    protected void shardOperationOnPrimary(PutChunkRequest request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<PutChunkReplicaRequest, PutChunkResponse>> listener) {
        try {
            PutChunkResponse response = new PutChunkResponse();
            this.transferTarget.continueTransfer(request, response);
            PutChunkReplicaRequest replicaRequest = new PutChunkReplicaRequest(request.shardId(), this.clusterService.localNode().getId(), request.transferId(), request.currentPos(), request.content(), request.isLast());
            listener.onResponse(new TransportReplicationAction.PrimaryResult<PutChunkReplicaRequest, PutChunkResponse>(replicaRequest, response));
        }
        catch (Exception ex) {
            listener.onFailure(ex);
        }
    }

    @Override
    protected TransportReplicationAction.ReplicaResult shardOperationOnReplica(PutChunkReplicaRequest shardRequest, IndexShard replica) {
        PutChunkResponse response = new PutChunkResponse();
        this.transferTarget.continueTransfer(shardRequest, response);
        return new TransportReplicationAction.ReplicaResult();
    }

    public static class Action
    extends ActionType<PutChunkResponse> {
        private static final String NAME = "internal:crate:blob/put_chunk";

        private Action() {
            super(NAME);
        }
    }
}

