/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob;

import io.crate.blob.BlobTransferTarget;
import io.crate.blob.StartBlobRequest;
import io.crate.blob.StartBlobResponse;
import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportStartBlob
extends TransportReplicationAction<StartBlobRequest, StartBlobRequest, StartBlobResponse> {
    public static final Action ACTION = new Action();
    private final BlobTransferTarget transferTarget;

    @Inject
    public TransportStartBlob(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, BlobTransferTarget transferTarget) {
        super(settings, ACTION.name(), transportService, clusterService, indicesService, threadPool, shardStateAction, StartBlobRequest::new, StartBlobRequest::new, "write");
        this.transferTarget = transferTarget;
        this.logger.trace("Constructor");
    }

    @Override
    protected StartBlobResponse newResponseInstance(StreamInput in) throws IOException {
        this.logger.trace("newResponseInstance");
        return new StartBlobResponse(in);
    }

    @Override
    protected void shardOperationOnPrimary(StartBlobRequest request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<StartBlobRequest, StartBlobResponse>> listener) {
        try {
            this.logger.trace("shardOperationOnPrimary {}", (Object)request);
            StartBlobResponse response = new StartBlobResponse();
            this.transferTarget.startTransfer(request, response);
            listener.onResponse(new TransportReplicationAction.PrimaryResult<StartBlobRequest, StartBlobResponse>(request, response));
        }
        catch (Exception ex) {
            listener.onFailure(ex);
        }
    }

    @Override
    protected TransportReplicationAction.ReplicaResult shardOperationOnReplica(StartBlobRequest request, IndexShard replica) {
        this.logger.trace("shardOperationOnReplica operating on replica {}", (Object)request);
        StartBlobResponse response = new StartBlobResponse();
        this.transferTarget.startTransfer(request, response);
        return new TransportReplicationAction.ReplicaResult();
    }

    public static class Action
    extends ActionType<StartBlobResponse> {
        private static final String NAME = "internal:crate:blob/start_blob";

        private Action() {
            super(NAME);
        }
    }
}

