/*
 * Decompiled with CFR 0.152.
 */
package io.crate.collections.accountable;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.LongConsumer;
import org.apache.lucene.util.RamUsageEstimator;

public class AccountableList<T>
extends AbstractList<T> {
    private static final int SOFT_MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    private static final Object[] DEFAULTCAPACITY_EMPTY_ELEMENTDATA = new Object[0];
    private static final int DEFAULT_CAPACITY = 10;
    private final LongConsumer allocateBytes;
    private Object[] elementData;
    private int size;

    public AccountableList(LongConsumer allocateBytes) {
        this.allocateBytes = allocateBytes;
        this.elementData = DEFAULTCAPACITY_EMPTY_ELEMENTDATA;
        allocateBytes.accept(4L);
    }

    @Override
    public T get(int index) {
        Objects.checkIndex(index, this.size);
        return (T)this.elementData[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void sort(Comparator<? super T> c) {
        Arrays.sort(this.elementData, 0, this.size, c);
    }

    @Override
    public boolean add(T t) {
        if (this.size == this.elementData.length) {
            this.elementData = this.grow(this.size + 1);
        }
        this.elementData[this.size] = t;
        ++this.size;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        if (numNew == 0) {
            return false;
        }
        Object[] elementData = this.elementData;
        int s = this.size;
        if (numNew > this.elementData.length - s) {
            elementData = this.grow(s + numNew);
        }
        System.arraycopy(a, 0, elementData, s, numNew);
        this.size = s + numNew;
        return true;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    private Object[] grow(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (oldCapacity > 0 || this.elementData != DEFAULTCAPACITY_EMPTY_ELEMENTDATA) {
            int newCapacity = AccountableList.newLength(oldCapacity, minCapacity - oldCapacity, oldCapacity >> 1);
            this.allocateBytes.accept(RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * (long)(newCapacity - oldCapacity))));
            this.elementData = Arrays.copyOf(this.elementData, newCapacity);
        } else {
            int length = Math.max(10, minCapacity);
            this.allocateBytes.accept(RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * (long)length)));
            this.elementData = new Object[length];
        }
        return this.elementData;
    }

    public static int newLength(int oldLength, int minGrowth, int prefGrowth) {
        int prefLength = oldLength + Math.max(minGrowth, prefGrowth);
        if (0 < prefLength && prefLength <= 0x7FFFFFF7) {
            return prefLength;
        }
        return AccountableList.hugeLength(oldLength, minGrowth);
    }

    private static int hugeLength(int oldLength, int minGrowth) {
        int minLength = oldLength + minGrowth;
        if (minLength < 0) {
            throw new OutOfMemoryError("Required array length " + oldLength + " + " + minGrowth + " is too large");
        }
        if (minLength <= 0x7FFFFFF7) {
            return 0x7FFFFFF7;
        }
        return minLength;
    }

    private static class SubList<T>
    extends AbstractList<T>
    implements RandomAccess {
        private final AccountableList<T> root;
        private final int offset;
        private final int size;

        public SubList(AccountableList<T> root, int fromIndex, int toIndex) {
            this.root = root;
            root.allocateBytes.accept(RamUsageEstimator.NUM_BYTES_OBJECT_REF + 8);
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        @Override
        public void sort(Comparator<? super T> c) {
            Arrays.sort(this.root.elementData, this.offset, this.offset + this.size, c);
        }

        @Override
        public T set(int index, T element) {
            Objects.checkIndex(index, this.size);
            Object oldValue = this.root.elementData[this.offset + index];
            this.root.elementData[this.offset + index] = element;
            return (T)oldValue;
        }

        @Override
        public T get(int index) {
            Objects.checkIndex(index, this.size);
            return (T)this.root.elementData[this.offset + index];
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

