/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.ResourceUnknownException;
import io.crate.exceptions.SchemaScopeException;
import io.crate.rest.action.HttpErrorStatus;
import io.crate.sql.Identifiers;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class SchemaUnknownException
extends ElasticsearchException
implements ResourceUnknownException,
SchemaScopeException {
    private static final String MESSAGE_TMPL = "Schema '%s' unknown";
    private final String schemaName;

    public static SchemaUnknownException of(String schema, List<String> candidates) {
        switch (candidates.size()) {
            case 0: {
                return new SchemaUnknownException(schema);
            }
            case 1: {
                return new SchemaUnknownException(schema, "Schema '" + schema + "' unknown. Maybe you meant '" + Identifiers.quoteIfNeeded((String)candidates.get(0)) + "'");
            }
        }
        String errorMsg = "Schema '" + schema + "' unknown. Maybe you meant one of: " + candidates.stream().map(Identifiers::quoteIfNeeded).collect(Collectors.joining(", "));
        return new SchemaUnknownException(schema, errorMsg);
    }

    public SchemaUnknownException(String schema) {
        this(schema, String.format(Locale.ENGLISH, MESSAGE_TMPL, schema));
    }

    private SchemaUnknownException(String schema, String errorMessage) {
        super(errorMessage, new Object[0]);
        this.schemaName = schema;
    }

    public SchemaUnknownException(StreamInput in) throws IOException {
        super(in);
        this.schemaName = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.schemaName);
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public HttpErrorStatus httpErrorStatus() {
        return HttpErrorStatus.SCHEMA_UNKNOWN;
    }
}

