/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl;

import io.crate.common.collections.Lists;
import io.crate.execution.ddl.RelationNameSwap;
import io.crate.execution.ddl.SwapRelationsRequest;
import io.crate.metadata.PartitionName;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.index.Index;

public class SwapRelationsOperation {
    private final AllocationService allocationService;
    private final DDLClusterStateService ddlClusterStateService;

    public SwapRelationsOperation(AllocationService allocationService, DDLClusterStateService ddlClusterStateService) {
        this.allocationService = allocationService;
        this.ddlClusterStateService = ddlClusterStateService;
    }

    public UpdatedState execute(ClusterState state, SwapRelationsRequest swapRelationsRequest) {
        UpdatedState stateAfterRename = this.applyRenameActions(state, swapRelationsRequest);
        List<RelationName> dropRelations = swapRelationsRequest.dropRelations();
        if (dropRelations.isEmpty()) {
            return stateAfterRename;
        }
        return this.applyDropRelations(stateAfterRename, dropRelations);
    }

    private UpdatedState applyDropRelations(UpdatedState updatedState, List<RelationName> dropRelations) {
        ClusterState stateAfterRename = updatedState.newState;
        Metadata.Builder updatedMetadata = Metadata.builder(stateAfterRename.metadata());
        RoutingTable.Builder routingBuilder = RoutingTable.builder(stateAfterRename.routingTable());
        for (RelationName dropRelation : dropRelations) {
            List<Index> indices = stateAfterRename.metadata().getIndices(dropRelation, List.of(), false, IndexMetadata::getIndex);
            for (Index index : indices) {
                String indexUUID = index.getUUID();
                updatedMetadata.remove(indexUUID);
                routingBuilder.remove(indexUUID);
                updatedState.newIndices.remove(indexUUID);
            }
            updatedMetadata.dropRelation(dropRelation);
        }
        ClusterState stateAfterDropRelations = ClusterState.builder(stateAfterRename).metadata(updatedMetadata).routingTable(routingBuilder.build()).build();
        return new UpdatedState(this.allocationService.reroute(this.applyDropTableClusterStateModifiers(stateAfterDropRelations, dropRelations), "indices drop after name switch"), updatedState.newIndices);
    }

    private ClusterState applyDropTableClusterStateModifiers(ClusterState stateAfterDropRelations, List<RelationName> dropRelations) {
        ClusterState updatedState = stateAfterDropRelations;
        for (RelationName dropRelation : dropRelations) {
            updatedState = this.ddlClusterStateService.onDropTable(updatedState, dropRelation);
        }
        return updatedState;
    }

    private UpdatedState applyRenameActions(ClusterState state, SwapRelationsRequest swapRelationsRequest) {
        RelationName target;
        RelationName source;
        HashSet<String> newIndexNames = new HashSet<String>();
        Metadata metadata = state.metadata();
        Metadata.Builder updatedMetadata = Metadata.builder(state.metadata());
        RoutingTable.Builder routingBuilder = RoutingTable.builder(state.routingTable());
        ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder().blocks(state.blocks());
        for (RelationNameSwap nameSwap : swapRelationsRequest.swapActions()) {
            source = nameSwap.source();
            target = nameSwap.target();
            RelationMetadata.Table sourceRelation = (RelationMetadata.Table)metadata.getRelation(source);
            RelationMetadata.Table targetRelation = (RelationMetadata.Table)metadata.getRelation(target);
            updatedMetadata.dropRelation(source).dropRelation(target).setTable(target, Lists.map(sourceRelation.columns(), ref -> ref.withReferenceIdent(new ReferenceIdent(target, ref.column()))), sourceRelation.settings(), sourceRelation.routingColumn(), sourceRelation.columnPolicy(), sourceRelation.pkConstraintName(), sourceRelation.checkConstraints(), sourceRelation.primaryKeys(), sourceRelation.partitionedBy(), sourceRelation.state(), sourceRelation.indexUUIDs(), sourceRelation.tableVersion() + 1L).setTable(source, Lists.map(targetRelation.columns(), ref -> ref.withReferenceIdent(new ReferenceIdent(source, ref.column()))), targetRelation.settings(), targetRelation.routingColumn(), targetRelation.columnPolicy(), targetRelation.pkConstraintName(), targetRelation.checkConstraints(), targetRelation.primaryKeys(), targetRelation.partitionedBy(), targetRelation.state(), targetRelation.indexUUIDs(), targetRelation.tableVersion() + 1L);
        }
        for (RelationNameSwap swapAction : swapRelationsRequest.swapActions()) {
            this.removeOccurrences(state, blocksBuilder, routingBuilder, updatedMetadata, swapAction.source());
            this.removeOccurrences(state, blocksBuilder, routingBuilder, updatedMetadata, swapAction.target());
        }
        for (RelationNameSwap relationNameSwap : swapRelationsRequest.swapActions()) {
            source = relationNameSwap.source();
            target = relationNameSwap.target();
            this.addSourceIndicesRenamedToTargetName(metadata, updatedMetadata, blocksBuilder, routingBuilder, source, target, newIndexNames::add);
            this.addSourceIndicesRenamedToTargetName(metadata, updatedMetadata, blocksBuilder, routingBuilder, target, source, newIndexNames::add);
        }
        ClusterState stateAfterSwap = ClusterState.builder(state).metadata(updatedMetadata).routingTable(routingBuilder.build()).blocks(blocksBuilder).build();
        ClusterState reroutedState = this.allocationService.reroute(this.applyClusterStateModifiers(stateAfterSwap, swapRelationsRequest.swapActions()), "indices name switch");
        return new UpdatedState(reroutedState, newIndexNames);
    }

    private ClusterState applyClusterStateModifiers(ClusterState newState, List<RelationNameSwap> swapActions) {
        ClusterState updatedState = newState;
        for (RelationNameSwap swapAction : swapActions) {
            updatedState = this.ddlClusterStateService.onSwapRelations(updatedState, swapAction.source(), swapAction.target());
        }
        return updatedState;
    }

    private void removeOccurrences(ClusterState state, ClusterBlocks.Builder blocksBuilder, RoutingTable.Builder routingBuilder, Metadata.Builder updatedMetadata, RelationName name) {
        Metadata metadata = state.metadata();
        List<Index> indices = metadata.getIndices(name, List.of(), false, IndexMetadata::getIndex);
        for (Index index : indices) {
            String indexUUID = index.getUUID();
            routingBuilder.remove(indexUUID);
            updatedMetadata.remove(indexUUID);
            blocksBuilder.removeIndexBlocks(indexUUID);
        }
    }

    private void addSourceIndicesRenamedToTargetName(Metadata metadata, Metadata.Builder updatedMetadata, ClusterBlocks.Builder blocksBuilder, RoutingTable.Builder routingBuilder, RelationName source, RelationName target, Consumer<String> onProcessedIndex) {
        List<Index> sourceIndices = metadata.getIndices(source, List.of(), false, IndexMetadata::getIndex);
        for (Index sourceIndex : sourceIndices) {
            String targetIndexName;
            IndexMetadata sourceMd = metadata.getIndexSafe(sourceIndex);
            if (sourceMd.partitionValues().isEmpty()) {
                targetIndexName = target.indexNameOrAlias();
            } else {
                PartitionName partitionName = new PartitionName(target, sourceMd.partitionValues());
                targetIndexName = partitionName.asIndexName();
            }
            IndexMetadata targetMd = IndexMetadata.builder(sourceMd).indexName(targetIndexName).incrementSettingsVersion().build();
            onProcessedIndex.accept(sourceIndex.getUUID());
            updatedMetadata.put(targetMd, true);
            blocksBuilder.addBlocks(targetMd);
            routingBuilder.addAsFromCloseToOpen(targetMd);
        }
    }

    static class UpdatedState {
        ClusterState newState;
        Set<String> newIndices;

        UpdatedState(ClusterState newState, Set<String> newIndices) {
            this.newState = newState;
            this.newIndices = newIndices;
        }
    }
}

