/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl;

import io.crate.execution.ddl.tables.MappingUtil;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.common.compress.CompressedXContent;

public final class Templates {
    private static final Logger LOGGER = LogManager.getLogger(Templates.class);

    public static IndexTemplateMetadata of(RelationMetadata.Table table) {
        assert (!table.partitionedBy().isEmpty()) : "table must be partitioned";
        RelationName relationName = table.name();
        String templateName = PartitionName.templateName(relationName.schema(), relationName.name());
        String templatePrefix = PartitionName.templatePrefix(relationName.schema(), relationName.name());
        return IndexTemplateMetadata.builder(templateName).version(null).patterns(List.of(templatePrefix)).putAlias(new AliasMetadata(relationName.indexNameOrAlias())).settings(table.settings()).putMapping(new CompressedXContent(Map.of("default", MappingUtil.createMapping(MappingUtil.AllocPosition.forNewTable(), table.pkConstraintName(), table.columns(), table.primaryKeys(), table.checkConstraints(), table.partitionedBy(), table.columnPolicy(), table.routingColumn())))).build();
    }

    public static IndexTemplateMetadata.Builder withName(IndexTemplateMetadata source, RelationName newName) {
        String targetTemplateName = PartitionName.templateName(newName.schema(), newName.name());
        String targetAlias = newName.indexNameOrAlias();
        IndexTemplateMetadata.Builder templateBuilder = IndexTemplateMetadata.builder(targetTemplateName).patterns(Collections.singletonList(PartitionName.templatePrefix(newName.schema(), newName.name()))).settings(source.settings()).putMapping(source.mapping()).putAlias(new AliasMetadata(targetAlias)).version(source.version());
        return templateBuilder;
    }
}

