/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.analyze.BoundAlterTable;
import io.crate.data.Row;
import io.crate.exceptions.RelationUnknown;
import io.crate.execution.ddl.tables.AddColumnRequest;
import io.crate.execution.ddl.tables.AlterTableRequest;
import io.crate.execution.ddl.tables.CloseTableRequest;
import io.crate.execution.ddl.tables.GCDanglingArtifactsRequest;
import io.crate.execution.ddl.tables.OpenTableRequest;
import io.crate.execution.ddl.tables.TransportAddColumn;
import io.crate.execution.ddl.tables.TransportAlterTable;
import io.crate.execution.ddl.tables.TransportCloseTable;
import io.crate.execution.ddl.tables.TransportGCDanglingArtifacts;
import io.crate.execution.ddl.tables.TransportOpenTable;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.TableInfo;
import io.crate.replication.logical.LogicalReplicationService;
import io.crate.replication.logical.metadata.Publication;
import io.crate.session.CollectingResultReceiver;
import io.crate.session.Session;
import io.crate.session.Sessions;
import io.crate.sql.tree.ColumnPolicy;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.TransportResize;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class AlterTableClient {
    public static final String RESIZE_PREFIX = ".resized.";
    private static final Logger LOGGER = LogManager.getLogger(AlterTableClient.class);
    private final ClusterService clusterService;
    private final NodeClient client;
    private final Sessions sessions;
    private final IndexScopedSettings indexScopedSettings;
    private final LogicalReplicationService logicalReplicationService;

    @Inject
    public AlterTableClient(ClusterService clusterService, NodeClient client, Sessions sessions, IndexScopedSettings indexScopedSettings, LogicalReplicationService logicalReplicationService) {
        this.clusterService = clusterService;
        this.client = client;
        this.sessions = sessions;
        this.indexScopedSettings = indexScopedSettings;
        this.logicalReplicationService = logicalReplicationService;
    }

    public CompletableFuture<Long> addColumn(AddColumnRequest addColumnRequest) {
        List<Reference> newReferences = addColumnRequest.references();
        String exceptionSubject = null;
        String warning = null;
        if (!addColumnRequest.pKeyIndices().isEmpty()) {
            exceptionSubject = "primary key";
        } else if (newReferences.stream().anyMatch(ref -> ref instanceof GeneratedReference)) {
            exceptionSubject = "generated";
        } else {
            for (Reference newRef : newReferences) {
                if (!newReferences.stream().anyMatch(r -> r.column().isChildOf(newRef.column())) || newRef.valueType().columnPolicy() != ColumnPolicy.IGNORED) continue;
                warning = "Adding a sub column to an OBJECT(IGNORED) parent may shade existing data of this column as the table isn't empty";
                break;
            }
        }
        if (exceptionSubject != null || warning != null) {
            String finalSubject = exceptionSubject;
            String finalWarning = warning;
            return this.getRowCount(addColumnRequest.relationName()).thenCompose(rowCount -> {
                if (rowCount > 0L) {
                    if (finalSubject != null) {
                        throw new UnsupportedOperationException("Cannot add a " + finalSubject + " column to a table that isn't empty");
                    }
                    LOGGER.warn(finalWarning);
                }
                return this.client.execute(TransportAddColumn.ACTION, addColumnRequest).thenApply(acknowledgedResponse -> -1L);
            });
        }
        return this.client.execute(TransportAddColumn.ACTION, addColumnRequest).thenApply(acknowledgedResponse -> -1L);
    }

    private CompletableFuture<Long> getRowCount(RelationName ident) {
        String stmt = String.format(Locale.ENGLISH, "SELECT COUNT(*) FROM \"%s\".\"%s\"", ident.schema(), ident.name());
        CollectingResultReceiver rowCountReceiver = new CollectingResultReceiver(Collectors.summingLong(row -> (Long)row.get(0)));
        try (Session session = this.sessions.newSystemSession();){
            session.quickExec(stmt, rowCountReceiver, Row.EMPTY);
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
        return rowCountReceiver.completionFuture();
    }

    public CompletableFuture<Long> closeOrOpen(RelationName relationName, boolean openTable, @Nullable PartitionName partitionName) {
        if (openTable) {
            OpenTableRequest request = new OpenTableRequest(relationName, partitionName == null ? List.of() : partitionName.values());
            return this.client.execute(TransportOpenTable.ACTION, request).thenApply(acknowledgedResponse -> -1L);
        }
        CloseTableRequest request = new CloseTableRequest(relationName, partitionName == null ? List.of() : partitionName.values());
        return this.client.execute(TransportCloseTable.ACTION, request).thenApply(acknowledgedResponse -> -1L);
    }

    public CompletableFuture<Long> setSettingsOrResize(BoundAlterTable analysis) {
        boolean isResizeOperationRequired;
        AlterTableClient.validateSettingsForPublishedTables(analysis.table().ident(), analysis.settings(), this.logicalReplicationService.publications(), this.indexScopedSettings);
        Settings settings = analysis.settings();
        boolean includesNumberOfShardsSetting = settings.hasValue("index.number_of_shards");
        boolean bl = isResizeOperationRequired = includesNumberOfShardsSetting && (!analysis.isPartitioned() || analysis.partitionName() != null);
        if (isResizeOperationRequired) {
            if (settings.size() > 1) {
                throw new IllegalArgumentException("Setting [number_of_shards] cannot be combined with other settings");
            }
            return this.resize(analysis);
        }
        return this.setSettings(analysis);
    }

    private CompletableFuture<Long> setSettings(BoundAlterTable analysis) {
        try {
            PartitionName partitionName = analysis.partitionName();
            AlterTableRequest request = new AlterTableRequest(analysis.table().ident(), partitionName == null ? List.of() : partitionName.values(), analysis.isPartitioned(), analysis.excludePartitions(), analysis.settings());
            return this.client.execute(TransportAlterTable.ACTION, request).thenApply(acknowledgedResponse -> -1L);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private CompletableFuture<Long> resize(BoundAlterTable analysis) {
        TableInfo table = analysis.table();
        PartitionName partitionName = analysis.partitionName();
        ClusterState currentState = this.clusterService.state();
        List<String> partitionValues = partitionName == null ? List.of() : partitionName.values();
        IndexMetadata sourceIndexMetadata = currentState.metadata().getIndex(table.ident(), partitionValues, true, im -> im);
        if (sourceIndexMetadata == null) {
            throw new RelationUnknown(String.format(Locale.ENGLISH, "Table/Partition '%s' does not exist", table.ident().fqn()));
        }
        int targetNumberOfShards = AlterTableClient.getNumberOfShards(analysis.settings());
        AlterTableClient.validateNumberOfShardsForResize(sourceIndexMetadata, targetNumberOfShards);
        AlterTableClient.validateReadOnlyIndexForResize(sourceIndexMetadata);
        ResizeRequest request = new ResizeRequest(table.ident(), partitionName == null ? List.of() : partitionName.values(), targetNumberOfShards);
        return ((CompletableFuture)this.deleteTempIndices().thenCompose(l -> this.client.execute(TransportResize.ACTION, request))).thenApply(resizeResponse -> 0L);
    }

    @VisibleForTesting
    static int getNumberOfShards(Settings settings) {
        return Objects.requireNonNull(settings.getAsInt("index.number_of_shards", null), "Setting 'number_of_shards' is missing");
    }

    @VisibleForTesting
    static void validateNumberOfShardsForResize(IndexMetadata indexMetadata, int targetNumberOfShards) {
        int currentNumberOfShards = indexMetadata.getNumberOfShards();
        if (currentNumberOfShards == targetNumberOfShards) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Table/partition is already allocated <%d> shards", currentNumberOfShards));
        }
        if (targetNumberOfShards < currentNumberOfShards && currentNumberOfShards % targetNumberOfShards != 0) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Requested number of shards: <%d> needs to be a factor of the current one: <%d>", targetNumberOfShards, currentNumberOfShards));
        }
    }

    @VisibleForTesting
    static void validateReadOnlyIndexForResize(IndexMetadata indexMetadata) {
        Boolean readOnly = indexMetadata.getSettings().getAsBoolean(IndexMetadata.INDEX_BLOCKS_WRITE_SETTING.getKey(), Boolean.FALSE);
        if (!readOnly.booleanValue()) {
            throw new IllegalStateException("Table/Partition needs to be at a read-only state. Use 'ALTER table ... set (\"blocks.write\"=true)' and retry");
        }
    }

    @VisibleForTesting
    static void validateSettingsForPublishedTables(RelationName relationName, Settings settings, Map<String, Publication> publications, IndexScopedSettings indexScopedSettings) {
        for (Map.Entry<String, Publication> entry : publications.entrySet()) {
            String publicationName = entry.getKey();
            Publication publication = entry.getValue();
            if (!publication.isForAllTables() && !publication.tables().contains(relationName)) continue;
            for (String key : settings.keySet()) {
                if (indexScopedSettings.isDynamicSetting(key)) continue;
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Setting [%s] cannot be applied to table '%s' because it is included in a logical replication publication '%s'", key, relationName.toString(), publicationName));
            }
        }
    }

    private CompletableFuture<Long> deleteTempIndices() {
        return this.client.execute(TransportGCDanglingArtifacts.ACTION, GCDanglingArtifactsRequest.INSTANCE).thenApply(acknowledgedResponse -> 0L);
    }
}

