/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class AlterTableRequest
extends AcknowledgedRequest<AlterTableRequest> {
    private final RelationName table;
    private final List<String> partitionValues;
    private final boolean isPartitioned;
    private final boolean excludePartitions;
    private final Settings settings;

    public AlterTableRequest(RelationName table, List<String> partitionValues, boolean isPartitioned, boolean excludePartitions, Settings settings) throws IOException {
        this.table = table;
        this.partitionValues = partitionValues;
        this.isPartitioned = isPartitioned;
        this.excludePartitions = excludePartitions;
        this.settings = settings;
    }

    public AlterTableRequest(StreamInput in) throws IOException {
        super(in);
        this.table = new RelationName(in);
        boolean before510 = in.getVersion().before(Version.V_5_10_0);
        if (before510) {
            String partitionIndexName = in.readOptionalString();
            this.partitionValues = partitionIndexName == null ? List.of() : PartitionName.fromIndexOrTemplate(partitionIndexName).values();
        } else {
            int numValues = in.readVInt();
            this.partitionValues = new ArrayList<String>(numValues);
            for (int i = 0; i < numValues; ++i) {
                this.partitionValues.add(in.readOptionalString());
            }
        }
        this.isPartitioned = in.readBoolean();
        this.excludePartitions = in.readBoolean();
        this.settings = Settings.readSettingsFromStream(in);
        if (before510) {
            in.readOptionalString();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.table.writeTo(out);
        boolean before510 = out.getVersion().before(Version.V_5_10_0);
        if (before510) {
            if (this.partitionValues.isEmpty()) {
                out.writeOptionalString(null);
            } else {
                String partitionIndexName = new PartitionName(this.table, this.partitionValues).asIndexName();
                out.writeOptionalString(partitionIndexName);
            }
        } else {
            out.writeVInt(this.partitionValues.size());
            for (String value : this.partitionValues) {
                out.writeOptionalString(value);
            }
        }
        out.writeBoolean(this.isPartitioned);
        out.writeBoolean(this.excludePartitions);
        Settings.writeSettingsToStream(out, this.settings);
        if (before510) {
            out.writeOptionalString(null);
        }
    }

    public RelationName tableIdent() {
        return this.table;
    }

    public List<String> partitionValues() {
        return this.partitionValues;
    }

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public boolean excludePartitions() {
        return this.excludePartitions;
    }

    public Settings settings() {
        return this.settings;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.table.hashCode();
        result = 31 * result + this.partitionValues.hashCode();
        result = 31 * result + (this.isPartitioned ? 1231 : 1237);
        result = 31 * result + (this.excludePartitions ? 1231 : 1237);
        result = 31 * result + this.settings.hashCode();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof AlterTableRequest)) return false;
        AlterTableRequest other = (AlterTableRequest)obj;
        if (!this.table.equals(other.table)) return false;
        if (!this.partitionValues.equals(other.partitionValues)) return false;
        if (this.isPartitioned != other.isPartitioned) return false;
        if (this.excludePartitions != other.excludePartitions) return false;
        if (!this.settings.equals(other.settings)) return false;
        return true;
    }
}

