/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class CloseTableRequest
extends AcknowledgedRequest<CloseTableRequest> {
    private final RelationName table;
    private final List<String> partitionValues;

    public CloseTableRequest(RelationName table, List<String> partitionValues) {
        this.table = table;
        this.partitionValues = partitionValues;
    }

    public CloseTableRequest(StreamInput in) throws IOException {
        super(in);
        this.table = new RelationName(in);
        if (in.getVersion().onOrAfter(Version.V_5_10_0)) {
            int numValues = in.readVInt();
            this.partitionValues = new ArrayList<String>(numValues);
            for (int i = 0; i < numValues; ++i) {
                this.partitionValues.add(in.readOptionalString());
            }
        } else {
            String partition = in.readOptionalString();
            this.partitionValues = partition == null ? List.of() : PartitionName.fromIndexOrTemplate(partition).values();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.table.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_5_10_0)) {
            out.writeVInt(this.partitionValues.size());
            for (String value : this.partitionValues) {
                out.writeOptionalString(value);
            }
        } else if (this.partitionValues.isEmpty()) {
            out.writeBoolean(false);
        } else {
            PartitionName partitionName = new PartitionName(this.table, this.partitionValues);
            out.writeBoolean(true);
            out.writeString(partitionName.asIndexName());
        }
    }

    public RelationName table() {
        return this.table;
    }

    public List<String> partitionValues() {
        return this.partitionValues;
    }
}

