/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import com.carrotsearch.hppc.IntArrayList;
import io.crate.analyze.BoundCreateTable;
import io.crate.analyze.TableParameters;
import io.crate.common.collections.Lists;
import io.crate.common.exceptions.Exceptions;
import io.crate.exceptions.RelationAlreadyExists;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.ddl.tables.CreateTableRequest;
import io.crate.execution.ddl.tables.TransportCreateTable;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.sql.tree.ColumnPolicy;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class CreateTableClient {
    protected static final Logger LOGGER = LogManager.getLogger(CreateTableClient.class);
    private final NodeClient client;

    public CreateTableClient(NodeClient client) {
        this.client = client;
    }

    public CompletableFuture<Long> create(BoundCreateTable createTable, Version minNodeVersion) {
        RelationName relationName = createTable.tableName();
        Map<ColumnIdent, Reference> references = createTable.columns();
        IntArrayList pKeysIndices = createTable.primaryKeysIndices();
        ColumnPolicy tableColumnPolicy = TableParameters.COLUMN_POLICY.get(createTable.settings());
        Settings.Builder settingsBuilder = Settings.builder().put(createTable.settings());
        settingsBuilder.remove(TableParameters.COLUMN_POLICY.getKey());
        if (!minNodeVersion.onOrAfter(Version.V_5_4_0)) {
            throw new UnsupportedOperationException("All nodes in the cluster must at least have version 5.4.0");
        }
        CreateTableRequest createTableRequest = new CreateTableRequest(relationName, createTable.pkConstraintName(), new ArrayList<Reference>(references.values()), pKeysIndices, createTable.getCheckConstraints(), settingsBuilder.build(), createTable.routingColumn(), tableColumnPolicy, Lists.map(createTable.partitionedBy(), Reference::column));
        return ((CompletableFuture)this.client.execute(TransportCreateTable.ACTION, createTableRequest).thenApply(resp -> {
            if (!resp.isAllShardsAcked() && LOGGER.isWarnEnabled()) {
                LOGGER.warn("CREATE TABLE `{}` was not acknowledged. This could lead to inconsistent state.", (Object)relationName.fqn());
            }
            return 1L;
        })).exceptionally(error -> {
            Throwable t = SQLExceptions.unwrap(error);
            String message = t.getMessage();
            Throwable cause = t.getCause();
            if ("mapping [default]".equals(message) && cause != null) {
                throw Exceptions.toRuntimeException((Throwable)cause);
            }
            throw Exceptions.toRuntimeException((Throwable)t);
        });
    }

    public static boolean isTableExistsError(Throwable t, @Nullable String templateName) {
        return (t = SQLExceptions.unwrap(t)) instanceof ResourceAlreadyExistsException || t instanceof RelationAlreadyExists || templateName != null && CreateTableClient.isTemplateAlreadyExistsException(t);
    }

    private static boolean isTemplateAlreadyExistsException(Throwable t) {
        return t instanceof IllegalArgumentException && t.getMessage() != null && t.getMessage().endsWith("already exists");
    }
}

