/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.metadata.RelationName;
import java.io.IOException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.NotNull;

public class DropConstraintRequest
extends AcknowledgedRequest<DropConstraintRequest> {
    private final RelationName relationName;
    private final String constraintName;

    public DropConstraintRequest(@NotNull RelationName relationName, @NotNull String constraintName) {
        this.relationName = relationName;
        this.constraintName = constraintName;
    }

    public DropConstraintRequest(StreamInput in) throws IOException {
        super(in);
        this.relationName = new RelationName(in);
        this.constraintName = in.readString();
    }

    public RelationName relationName() {
        return this.relationName;
    }

    public String constraintName() {
        return this.constraintName;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.relationName.writeTo(out);
        out.writeString(this.constraintName);
    }
}

