/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import com.carrotsearch.hppc.cursors.IntObjectCursor;
import io.crate.concurrent.CountDown;
import io.crate.concurrent.MultiActionListener;
import io.crate.execution.ddl.tables.AlterTableTarget;
import io.crate.execution.ddl.tables.CloseTableRequest;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateService;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.close.TransportVerifyShardBeforeCloseAction;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class TransportCloseTable
extends TransportMasterNodeAction<CloseTableRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private static final Logger LOGGER = LogManager.getLogger(TransportCloseTable.class);
    public static final int INDEX_CLOSED_BLOCK_ID = 4;
    private final TransportVerifyShardBeforeCloseAction verifyShardBeforeClose;
    private final AllocationService allocationService;
    private final DDLClusterStateService ddlClusterStateService;
    private final ActiveShardsObserver activeShardsObserver;

    @Inject
    public TransportCloseTable(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, DDLClusterStateService ddlClusterStateService, TransportVerifyShardBeforeCloseAction verifyShardBeforeClose) {
        super(ACTION.name(), transportService, clusterService, threadPool, CloseTableRequest::new);
        this.allocationService = allocationService;
        this.ddlClusterStateService = ddlClusterStateService;
        this.verifyShardBeforeClose = verifyShardBeforeClose;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(CloseTableRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        assert (state.nodes().getMinNodeVersion().onOrAfter(Version.V_4_3_0)) : "All nodes must be on 4.3 to use the new dedicated close action";
        this.clusterService.submitStateUpdateTask("add-block-close-table", new AddCloseBlocksTask(listener, request));
    }

    static ClusterState closeRoutingTable(ClusterState currentState, AlterTableTarget target, DDLClusterStateService ddlClusterStateService, Map<Index, ClusterBlock> blockedIndices, Map<Index, AcknowledgedResponse> results) {
        Metadata.Builder metadata;
        boolean removeRoutingTable = currentState.nodes().getMinNodeVersion().before(Version.V_4_3_0);
        ClusterState updatedState = currentState;
        RelationMetadata.Table table = (RelationMetadata.Table)updatedState.metadata().getRelation(target.table());
        List<String> partitionValues = target.partitionValues();
        if (partitionValues.isEmpty()) {
            updatedState = ddlClusterStateService.onCloseTable(updatedState, target.table());
            metadata = Metadata.builder(updatedState.metadata());
            metadata.setTable(table.name(), table.columns(), table.settings(), table.routingColumn(), table.columnPolicy(), table.pkConstraintName(), table.checkConstraints(), table.primaryKeys(), table.partitionedBy(), IndexMetadata.State.CLOSE, table.indexUUIDs(), table.tableVersion() + 1L);
        } else {
            PartitionName partitionName = new PartitionName(target.table(), partitionValues);
            updatedState = ddlClusterStateService.onCloseTablePartition(updatedState, partitionName);
            metadata = Metadata.builder(updatedState.metadata());
        }
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(updatedState.blocks());
        RoutingTable.Builder routingTable = RoutingTable.builder(updatedState.routingTable());
        HashSet<String> closedIndices = new HashSet<String>();
        for (Map.Entry<Index, AcknowledgedResponse> result : results.entrySet()) {
            Index index = result.getKey();
            boolean acknowledged = result.getValue().isAcknowledged();
            try {
                if (!acknowledged) {
                    LOGGER.debug("verification of shards before closing {} failed", (Object)index);
                    continue;
                }
                IndexMetadata indexMetadata = metadata.getSafe(index);
                if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                    LOGGER.debug("verification of shards before closing {} succeeded but index is already closed", (Object)index);
                    assert (currentState.blocks().hasIndexBlock(index.getUUID(), IndexMetadata.INDEX_CLOSED_BLOCK));
                    continue;
                }
                ClusterBlock closingBlock = blockedIndices.get(index);
                if (!currentState.blocks().hasIndexBlock(index.getUUID(), closingBlock)) {
                    LOGGER.debug("verification of shards before closing {} succeeded but block has been removed in the meantime", (Object)index);
                    continue;
                }
                Set<Index> restoringIndices = RestoreService.restoringIndices(updatedState, Set.of(index));
                if (!restoringIndices.isEmpty()) {
                    result.setValue(new AcknowledgedResponse(false));
                    LOGGER.debug("verification of shards before closing {} succeeded but index is being restored in the meantime", (Object)index);
                    continue;
                }
                Set<Index> snapshottingIndices = SnapshotsService.snapshottingIndices(updatedState, Set.of(index));
                if (!snapshottingIndices.isEmpty()) {
                    result.setValue(new AcknowledgedResponse(false));
                    LOGGER.debug("verification of shards before closing {} succeeded but index is being snapshot in the meantime", (Object)index);
                    continue;
                }
                blocks.removeIndexBlockWithId(index.getUUID(), 4);
                blocks.addIndexBlock(index.getUUID(), IndexMetadata.INDEX_CLOSED_BLOCK);
                IndexMetadata.Builder updatedMetadata = IndexMetadata.builder(indexMetadata).state(IndexMetadata.State.CLOSE);
                if (removeRoutingTable) {
                    metadata.put(updatedMetadata);
                    routingTable.remove(index.getUUID());
                } else {
                    metadata.put(updatedMetadata.settingsVersion(indexMetadata.getSettingsVersion() + 1L).settings(Settings.builder().put(indexMetadata.getSettings()).put(IndexMetadata.VERIFIED_BEFORE_CLOSE_SETTING.getKey(), true)));
                    routingTable.addAsFromOpenToClose(metadata.getSafe(index));
                }
                LOGGER.debug("closing index {} succeeded", (Object)index);
                closedIndices.add(index.getName());
            }
            catch (IndexNotFoundException e) {
                LOGGER.debug("index {} has been deleted since it was blocked before closing, ignoring", (Object)index);
            }
        }
        LOGGER.info("completed closing of indices {}", closedIndices);
        return ClusterState.builder(currentState).blocks(blocks).metadata(metadata).routingTable(routingTable.build()).build();
    }

    @Override
    protected ClusterBlockException checkBlock(CloseTableRequest request, ClusterState state) {
        if (TransportCloseTable.isEmptyPartitionedTable(request.table(), state)) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
        String[] indexNames = (String[])state.metadata().getIndices(request.table(), request.partitionValues(), false, idxMd -> idxMd.getIndex().getName()).toArray(String[]::new);
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indexNames);
    }

    public static boolean isEmptyPartitionedTable(RelationName relationName, ClusterState clusterState) {
        List<IndexMetadata> indices = clusterState.metadata().getIndices(relationName, List.of(), false, imd -> imd);
        return indices.isEmpty();
    }

    private static ClusterState addCloseBlocks(ClusterState currentState, List<Index> openIndices, Map<Index, ClusterBlock> blockedIndices) {
        Metadata.Builder metadata = Metadata.builder(currentState.metadata());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        Set<Index> restoringIndices = RestoreService.restoringIndices(currentState, openIndices);
        if (!restoringIndices.isEmpty()) {
            throw new IllegalArgumentException("Cannot close indices that are being restored: " + String.valueOf(restoringIndices));
        }
        Set<Index> snapshottingIndices = SnapshotsService.snapshottingIndices(currentState, openIndices);
        if (!snapshottingIndices.isEmpty()) {
            throw new SnapshotInProgressException("Cannot close indices that are being snapshotted: " + String.valueOf(snapshottingIndices) + ". Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        for (Index index : openIndices) {
            ClusterBlock indexBlock = null;
            Set<ClusterBlock> clusterBlocks = currentState.blocks().indices().get(index.getUUID());
            if (clusterBlocks != null) {
                for (ClusterBlock clusterBlock : clusterBlocks) {
                    if (clusterBlock.id() != 4) continue;
                    indexBlock = clusterBlock;
                    break;
                }
            }
            if (indexBlock == null) {
                indexBlock = new ClusterBlock(4, UUIDs.randomBase64UUID(), "Table or partition preparing to close. Reopen the table to allow writes again or retry closing the table to fully close it.", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE));
            }
            assert (Strings.hasLength(indexBlock.uuid())) : "Closing block should have a UUID";
            blocks.addIndexBlock(index.getUUID(), indexBlock);
            blockedIndices.put(index, indexBlock);
        }
        return ClusterState.builder(currentState).blocks(blocks).metadata(metadata).routingTable(currentState.routingTable()).build();
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "internal:crate:sql/table_or_partition/close";

        private Action() {
            super(NAME);
        }
    }

    private final class AddCloseBlocksTask
    extends ClusterStateUpdateTask {
        private final ActionListener<AcknowledgedResponse> listener;
        private final CloseTableRequest request;
        private final Map<Index, ClusterBlock> blockedIndices = new HashMap<Index, ClusterBlock>();

        private AddCloseBlocksTask(ActionListener<AcknowledgedResponse> listener, CloseTableRequest request) {
            this.listener = listener;
            this.request = request;
        }

        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            RelationName table = this.request.table();
            List<Index> openIndices = currentState.metadata().getIndices(table, this.request.partitionValues(), false, imd -> imd.getState() == IndexMetadata.State.CLOSE ? null : imd.getIndex());
            if (openIndices.isEmpty()) {
                return currentState;
            }
            return TransportCloseTable.addCloseBlocks(currentState, openIndices, this.blockedIndices);
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.listener.onFailure(e);
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            if (this.blockedIndices.isEmpty() && TransportCloseTable.isEmptyPartitionedTable(this.request.table(), newState)) {
                TransportCloseTable.this.clusterService.submitStateUpdateTask("close-indices", new CloseRoutingTableTask(Priority.URGENT, this.blockedIndices, Map.of(), this.request, this.listener));
                return;
            }
            if (oldState == newState) {
                assert (this.blockedIndices.isEmpty()) : "List of blocked indices is not empty but cluster state wasn't changed";
                this.listener.onResponse(new AcknowledgedResponse(true));
                return;
            }
            assert (!this.blockedIndices.isEmpty()) : "List of blocked indices is empty but cluster state was changed";
            TransportCloseTable.this.threadPool.executor("management").execute(new WaitForClosedBlocksApplied(this.blockedIndices, ActionListener.wrap(results -> TransportCloseTable.this.clusterService.submitStateUpdateTask("close-indices", new CloseRoutingTableTask(Priority.URGENT, this.blockedIndices, (Map<Index, AcknowledgedResponse>)results, this.request, this.listener)), this.listener::onFailure)));
        }
    }

    class WaitForClosedBlocksApplied
    extends ActionRunnable<Map<Index, AcknowledgedResponse>> {
        private final Map<Index, ClusterBlock> blockedIndices;

        private WaitForClosedBlocksApplied(Map<Index, ClusterBlock> blockedIndices, ActionListener<Map<Index, AcknowledgedResponse>> listener) {
            super(listener);
            if (blockedIndices == null || blockedIndices.isEmpty()) {
                throw new IllegalArgumentException("Cannot wait for closed blocks to be applied, list of blocked indices is empty or null");
            }
            this.blockedIndices = blockedIndices;
        }

        @Override
        public void doRun() throws Exception {
            ConcurrentHashMap results = new ConcurrentHashMap();
            CountDown countDown = new CountDown(this.blockedIndices.size());
            ClusterState state = TransportCloseTable.this.clusterService.state();
            this.blockedIndices.forEach((index, block) -> this.waitForShardsReadyForClosing((Index)index, (ClusterBlock)block, state, response -> {
                results.put(index, response);
                if (countDown.countDown()) {
                    this.listener.onResponse(Collections.unmodifiableMap(results));
                }
            }));
        }

        private void waitForShardsReadyForClosing(Index index, ClusterBlock closingBlock, ClusterState state, Consumer<AcknowledgedResponse> onResponse) {
            IndexMetadata indexMetadata = state.metadata().index(index);
            if (indexMetadata == null) {
                TransportCloseTable.this.logger.debug("index {} has been blocked before closing and is now deleted, ignoring", (Object)index);
                onResponse.accept(new AcknowledgedResponse(true));
                return;
            }
            IndexRoutingTable indexRoutingTable = state.routingTable().index(index);
            if (indexRoutingTable == null || indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                assert (state.blocks().hasIndexBlock(index.getUUID(), IndexMetadata.INDEX_CLOSED_BLOCK));
                TransportCloseTable.this.logger.debug("index {} has been blocked before closing and is already closed, ignoring", (Object)index);
                onResponse.accept(new AcknowledgedResponse(true));
                return;
            }
            ImmutableOpenIntMap<IndexShardRoutingTable> shards = indexRoutingTable.shards();
            MultiActionListener<ReplicationResponse, AtomicBoolean, AcknowledgedResponse> multiListener = new MultiActionListener<ReplicationResponse, AtomicBoolean, AcknowledgedResponse>(shards.size(), () -> new AtomicBoolean(true), (s, resp) -> {
                ReplicationResponse.ShardInfo shardInfo = resp.getShardInfo();
                if (shardInfo.getFailed() > 0) {
                    s.set(false);
                }
            }, s -> new AcknowledgedResponse(s.get()), ActionListener.wrap((Response resp) -> onResponse.accept((AcknowledgedResponse)resp), (Exception exception) -> onResponse.accept(new AcknowledgedResponse(false))));
            for (IntObjectCursor<IndexShardRoutingTable> intObjectCursor : shards) {
                IndexShardRoutingTable shardRoutingTable = (IndexShardRoutingTable)intObjectCursor.value;
                this.sendVerifyShardBeforeCloseRequest(shardRoutingTable, closingBlock, multiListener);
            }
        }

        private void sendVerifyShardBeforeCloseRequest(IndexShardRoutingTable shardRoutingTable, ClusterBlock closingBlock, ActionListener<ReplicationResponse> listener) {
            ShardId shardId = shardRoutingTable.shardId();
            if (shardRoutingTable.primaryShard().unassigned()) {
                TransportCloseTable.this.logger.debug("primary shard {} is unassigned, ignoring", (Object)shardId);
                ReplicationResponse response = new ReplicationResponse();
                response.setShardInfo(new ReplicationResponse.ShardInfo(shardRoutingTable.size(), shardRoutingTable.size(), new ReplicationResponse.ShardInfo.Failure[0]));
                listener.onResponse(response);
                return;
            }
            TransportVerifyShardBeforeCloseAction.ShardRequest shardRequest = new TransportVerifyShardBeforeCloseAction.ShardRequest(shardId, true, closingBlock);
            ((CompletableFuture)TransportCloseTable.this.verifyShardBeforeClose.execute(shardRequest).thenCompose(replicationResponse -> TransportCloseTable.this.verifyShardBeforeClose.execute(new TransportVerifyShardBeforeCloseAction.ShardRequest(shardId, false, closingBlock)))).whenComplete(listener);
        }
    }

    private final class CloseRoutingTableTask
    extends ClusterStateUpdateTask {
        private final Map<Index, AcknowledgedResponse> results;
        private final Map<Index, ClusterBlock> blockedIndices;
        private final ActionListener<AcknowledgedResponse> listener;
        private final CloseTableRequest request;
        boolean acknowledged;

        private CloseRoutingTableTask(Priority priority, Map<Index, ClusterBlock> blockedIndices, Map<Index, AcknowledgedResponse> results, CloseTableRequest request, ActionListener<AcknowledgedResponse> listener) {
            super(priority);
            this.acknowledged = true;
            this.blockedIndices = blockedIndices;
            this.results = results;
            this.listener = listener;
            this.request = request;
        }

        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            AlterTableTarget alterTableTarget = AlterTableTarget.of(currentState, this.request.table(), this.request.partitionValues());
            ClusterState updatedState = TransportCloseTable.closeRoutingTable(currentState, alterTableTarget, TransportCloseTable.this.ddlClusterStateService, this.blockedIndices, this.results);
            for (Map.Entry<Index, AcknowledgedResponse> result : this.results.entrySet()) {
                if (!result.getValue().isAcknowledged()) {
                    this.acknowledged = false;
                    break;
                }
                IndexMetadata updatedMetadata = updatedState.metadata().index(result.getKey());
                if (updatedMetadata == null || updatedMetadata.getState() == IndexMetadata.State.CLOSE) continue;
                this.acknowledged = false;
                break;
            }
            return TransportCloseTable.this.allocationService.reroute(updatedState, "indices closed");
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.listener.onFailure(e);
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            String[] indices = (String[])this.results.entrySet().stream().filter(result -> ((AcknowledgedResponse)result.getValue()).isAcknowledged()).map(result -> ((Index)result.getKey()).getUUID()).filter(indexUUID -> newState.routingTable().hasIndex((String)indexUUID)).toArray(String[]::new);
            if (indices.length > 0) {
                TransportCloseTable.this.activeShardsObserver.waitForActiveShards(indices, ActiveShardCount.ONE, this.request.ackTimeout(), shardsAcknowledged -> {
                    if (!shardsAcknowledged.booleanValue() && LOGGER.isDebugEnabled()) {
                        LOGGER.debug("[{}] indices closed, but the operation timed out while waiting for enough shards to be started.", (Object)Arrays.toString(indices));
                    }
                    this.listener.onResponse(new AcknowledgedResponse(this.acknowledged));
                }, this.listener::onFailure);
            } else {
                this.listener.onResponse(new AcknowledgedResponse(this.acknowledged));
            }
        }
    }
}

